/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.notice.server.util;

import com.mini.framework.third.weixin.notice.server.model.WeixinNoticeType;
import com.mini.framework.third.weixin.notice.server.model.resp.ServerAndUserShower;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinAskMsg;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinNotice;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.RegexUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;

public class WeixinNoticeMsgFactory {
    private static final String msgTypeNodeKey = "MsgType";
    private static final String eventNodeKey = "Event";
    private static final String fromNodeKey = "FromUserName";
    private static final String toNodeKey = "ToUserName";

    public static WeixinNotice readXmlNotice(String xmlNotice) {
        String type = RegexUtil.xmlRegexNodeValue((String)msgTypeNodeKey, (String)xmlNotice);
        String subType = RegexUtil.xmlRegexNodeValue((String)eventNodeKey, (String)xmlNotice);
        AssertUtil.assertNotNull((Object)type, (String)"\u6ca1\u6709\u89e3\u6790\u5230\u901a\u77e5\u7c7b\u578b,xmlNotice:%s", (Object[])new Object[]{xmlNotice});
        if ("event".equals(type)) {
            type = type + "." + subType;
        }
        WeixinNoticeType noticeType = WeixinNoticeType.get(type);
        AssertUtil.assertNotNull((Object)((Object)noticeType), (String)"\u6ca1\u6709\u4e0e%s\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b", (Object[])new Object[]{type});
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("utf-8"));
        AssertUtil.assertNotNull(noticeType.getClazz(), (String)"%s\u7684class\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{noticeType});
        xstream.processAnnotations(noticeType.getClazz());
        xstream.autodetectAnnotations(true);
        WeixinNotice weixinNotice = (WeixinNotice)xstream.fromXML(xmlNotice);
        weixinNotice.setOriginXmlMessage(xmlNotice);
        weixinNotice.setWeixinNoticeType(noticeType);
        return weixinNotice;
    }

    public static void fillShower(String xmlNotice, ServerAndUserShower shower) {
        String to = RegexUtil.xmlRegexNodeValue((String)toNodeKey, (String)xmlNotice);
        String from = RegexUtil.xmlRegexNodeValue((String)fromNodeKey, (String)xmlNotice);
        shower.setServAcc(to);
        shower.setOpenid(from);
    }

    public static String toXmlAsk(WeixinAskMsg weixinAskMsg) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("utf-8"));
        xstream.processAnnotations(WeixinAskMsg.class);
        xstream.autodetectAnnotations(true);
        String xml = xstream.toXML((Object)weixinAskMsg);
        return xml;
    }

    public static String showAccount(String body) {
        String to = RegexUtil.xmlRegexNodeValue((String)toNodeKey, (String)body);
        return to;
    }

    public static String showOpenid(String body) {
        String from = RegexUtil.xmlRegexNodeValue((String)fromNodeKey, (String)body);
        return from;
    }
}

