/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.model.menu;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.server.model.menu.WeixinServerButtonType;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class WeixinServerButton {
    @SerializedName(value="type")
    private WeixinServerButtonType type;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="key")
    private String key;
    @SerializedName(value="url")
    private String url;
    @SerializedName(value="appid")
    private String appid;
    @SerializedName(value="pagepath")
    private String namespace;
    @SerializedName(value="sub_button")
    private List<WeixinServerButton> subButtons;

    public WeixinServerButtonType getType() {
        return this.type;
    }

    public void setType(WeixinServerButtonType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<WeixinServerButton> getSubButtons() {
        return this.subButtons;
    }

    public void setSubButtons(List<WeixinServerButton> subButtons) {
        this.subButtons = subButtons;
    }

    public WeixinServerButton(WeixinServerButtonType type, String name, String key, String url, String appid, String namespace) {
        this.type = type;
        this.name = name;
        this.key = key;
        this.url = url;
        this.appid = appid;
        this.namespace = namespace;
    }

    public static WeixinServerButton createLinkUrlButton(String name, String key, String url) {
        return new WeixinServerButton(WeixinServerButtonType.link, name, key, url, null, null);
    }

    public static WeixinServerButton createLinkMappButton(String name, String key, String appid, String namespace, String defaultUrl) {
        return new WeixinServerButton(WeixinServerButtonType.linkMapp, name, key, defaultUrl, appid, namespace);
    }

    public static WeixinServerButton createButtonByType(WeixinServerButtonType type, String name, String key) {
        AssertUtil.assertSupport((!type.matchType(WeixinServerButtonType.linkMapp) ? 1 : 0) != 0, (String)"linkMapp\u4e0d\u80fd\u4f7f\u7528\u8fd9\u4e2a\u65b9\u6cd5", (Object[])new Object[0]);
        AssertUtil.assertSupport((!type.matchType(WeixinServerButtonType.link) ? 1 : 0) != 0, (String)"linkMapp\u4e0d\u80fd\u4f7f\u7528\u8fd9\u4e2a\u65b9\u6cd5", (Object[])new Object[0]);
        return new WeixinServerButton(type, name, key, null, null, null);
    }

    public List<WeixinServerButton> sureHaveSubList() {
        this.subButtons = Optional.ofNullable(this.subButtons).orElse(new ArrayList());
        return this.subButtons;
    }

    public WeixinServerButton addSubButton(WeixinServerButton button) {
        this.sureHaveSubList().add(button);
        return this;
    }

    public WeixinServerButtonType showTypeIfGroup() {
        if (this.subButtons != null) {
            return Optional.ofNullable(this.type).orElse(WeixinServerButtonType.group);
        }
        return this.type;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

