/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.util;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public interface ErrorHandlerResponse {
    public static final Map<Integer, StatusCode> errorMap = ErrorHandlerResponse.initErrorMap();

    public static Map<Integer, StatusCode> initErrorMap() {
        LinkedHashMap<Integer, StatusCode> errorMap = new LinkedHashMap<Integer, StatusCode>();
        errorMap.put(40102, Status.Busy.dataUnConfigSite);
        errorMap.put(47001, Status.Third.wxClientFormatErr);
        errorMap.put(40169, Status.Third.wxLimitHint);
        errorMap.put(40163, Status.BadReq.unsupportWeixinAuthCodeUsed);
        errorMap.put(40029, Status.BadReq.unsupportWeixinAuthCodeInvalid);
        errorMap.put(45026, Status.Third.wxTemplateNumLimit);
        errorMap.put(48011, Status.Third.wxTemplateDisabled);
        errorMap.put(40037, Status.Third.wxTemplateInvalid);
        errorMap.put(42001, Status.BadReq.expireWeixinAccessToken);
        return errorMap;
    }

    default public void handle(Map<Integer, StatusCode> errorMap, String message, Object ... params) {
        StatusCode statusCode = errorMap.get(this.getCode());
        statusCode = statusCode == null ? Status.Third.weixin : statusCode;
        String thirdError = String.format("error:%s,msg:%s", this.getCode(), this.getMsg());
        AssertUtil.simpleAssertByStatus((this.getCode() == 0 ? 1 : 0) != 0, (StatusCode)statusCode, (String)(thirdError + message), (Object[])params);
    }

    default public void handle(String errorMessage, Object ... params) {
        String.format(errorMessage, new Object[params.length]);
        this.handle(errorMap, errorMessage, params);
    }

    public int getCode();

    public String getMsg();
}

