/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.util.cache;

import com.mini.framework.third.weixin.wxpay.util.cache.BeanExpireHolder;
import com.mini.framework.third.weixin.wxpay.util.cache.BeanKey;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class MemoryBeanCache<B> {
    private final Long expireSeconds;
    private final Map<String, BeanExpireHolder<B>> beanCache = new ConcurrentHashMap<String, BeanExpireHolder<B>>();

    private MemoryBeanCache(Long expireSeconds) {
        this.expireSeconds = expireSeconds;
    }

    public B get(BeanKey keyGetter, Supplier<B> beanSupplier) {
        return this.get(keyGetter.showBeanFeatureKey(), beanSupplier);
    }

    public B get(String key, Supplier<B> beanSupplier) {
        Optional<Object> cacheBeanOptional = Optional.ofNullable(this.beanCache.get(key)).filter(BeanExpireHolder::ifNotNowExpire).map(BeanExpireHolder::getBean);
        return (B)cacheBeanOptional.orElseGet(() -> {
            Object newBean = beanSupplier.get();
            this.beanCache.put(key, new BeanExpireHolder(this.expireSeconds, newBean));
            return newBean;
        });
    }

    public static <SB> MemoryBeanCache<SB> createMemory(long expireSeconds) {
        return new MemoryBeanCache(expireSeconds);
    }
}

