/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.util.certificate;

import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.third.weixin.wxpay.util.certificate.CertificateSignatureRequireParams;
import com.mini.framework.third.weixin.wxpay.util.certificate.HandlerAfterCertificateSignature;
import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateConfig;
import com.mini.framework.third.weixin.wxpay.v3.exception.WxpaySignatureConfigException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.params.MapParams;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;

public class WxpayMarketCertificateContainer {
    private final String marketKey;
    private final String certificateSerialNumber;
    private final String certificateContentString;

    public WxpayMarketCertificateContainer(WxpayMarketCertificateConfig certificateConfig) {
        this(certificateConfig.sureHaveMarketKeyForSignature(), certificateConfig.sureHaveSerialNumberForSignature(), certificateConfig.sureHaveContentByteStringForSignature());
    }

    public WxpayMarketCertificateContainer(String marketKey, String certificateSerialNumber, String certificateContentString) {
        AssertUtil.assertMethodRequire((Object)"marketKey", (String)marketKey);
        AssertUtil.assertMethodRequire((Object)"certificateSerialNumber", (String)certificateSerialNumber);
        AssertUtil.assertMethodRequire((Object)"certificateContentString", (String)certificateContentString);
        WxpayMarketCertificateContainer.createPrivateKeyByContentString(certificateContentString);
        this.marketKey = marketKey;
        this.certificateSerialNumber = certificateSerialNumber;
        this.certificateContentString = certificateContentString;
    }

    public static WxpayMarketCertificateContainer createByCertificateConfig(WxpayMarketCertificateConfig certificateConfig) {
        return new WxpayMarketCertificateContainer(certificateConfig);
    }

    public String getMarketKey() {
        return this.marketKey;
    }

    public String getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public String getCertificateContentString() {
        return this.certificateContentString;
    }

    public String sureHaveMarketKeyForSignature() throws WxpaySignatureConfigException {
        if (this.marketKey == null) {
            throw new WxpaySignatureConfigException("\u914d\u7f6e\u53c2\u6570:marketKey \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        return this.marketKey;
    }

    public String sureHaveCertificateSerialNumberForSignature() throws WxpaySignatureConfigException {
        if (this.certificateSerialNumber == null) {
            throw new WxpaySignatureConfigException("\u914d\u7f6e\u53c2\u6570:serialNumber \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        return this.certificateSerialNumber;
    }

    public String sureHaveCertificateContentStringForSignature() throws WxpaySignatureConfigException {
        if (this.certificateContentString == null) {
            throw new WxpaySignatureConfigException("\u914d\u7f6e\u53c2\u6570:contentByteString \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        return this.certificateContentString;
    }

    public void signatureThenFillBack(CertificateSignatureRequireParams params, HandlerAfterCertificateSignature target) {
        String nonceStr = RandomStringUtils.randomAlphanumeric((int)20);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String signature = this.countSignature(params.sureHaveApiMethodForSignature(), params.sureHaveApiUrlPathForSignature(), timestamp, nonceStr, params.sureHaveRequestBodyForSignature());
        String authToken = this.countAuthToken(params.sureHaveApiMethodForSignature(), params.sureHaveApiUrlPathForSignature(), params.sureHaveRequestBodyForSignature(), nonceStr, timestamp, signature);
        target.foundSignature(signature);
        target.foundHeaderAuthToken(authToken);
    }

    private String countAuthToken(String method, String apiUrl, String body, String nonceStr, String timestamp, String signature) {
        MapParams params = MapParams.build().param("mchid", (Object)this.marketKey).param("nonce_str", (Object)nonceStr).param("timestamp", (Object)timestamp).param("serial_no", (Object)this.certificateSerialNumber).param("signature", (Object)signature);
        String token = params.entrySet().stream().map(entry -> String.format("%s=\"%s\"", entry.getKey(), entry.getValue())).collect(Collectors.joining(","));
        return "WECHATPAY2-SHA256-RSA2048 " + token;
    }

    private String countSignature(String method, String apiUrl, String timestamp, String nonceStr, String body) {
        String massage = Stream.of(method, apiUrl, timestamp, nonceStr, body).map(Objects::toString).collect(Collectors.joining("\n", "", "\n"));
        return WxpayMarketCertificateContainer.signatureThenBase64Message(massage, this.certificateContentString);
    }

    public static String signatureThenBase64Message(String message, String certDataString) {
        try {
            Signature signatureTool = WxpayMarketCertificateContainer.createSHA256withRSASignature();
            PrivateKey yourPrivateKey = WxpayMarketCertificateContainer.createPrivateKeyByContentString(certDataString);
            signatureTool.initSign(yourPrivateKey);
            signatureTool.update(message.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signatureTool.sign());
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new HandleIOException((Throwable)e, "\u7b7e\u540d\u7684\u65f6\u5019\u51fa\u9519", new Object[0]);
        }
    }

    public static Signature createSHA256withRSASignature() {
        try {
            return Signature.getInstance("SHA256withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleIOException((Throwable)e, "\u521b\u5efa\u4e00\u4e2a SHA256withRSA \u7b7e\u540d\u5b9e\u4f8b\u5931\u8d25", new Object[0]);
        }
    }

    public static PrivateKey createPrivateKeyByContentString(String contentString) {
        AssertUtil.assertMethodRequire((Object)contentString, (String)"certificateContentString");
        String clearContent = contentString.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(clearContent)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleIOException((Throwable)e, "\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA", new Object[0]);
        }
        catch (InvalidKeySpecException e) {
            throw new HandleIOException((Throwable)e, "\u65e0\u6548\u7684\u5bc6\u94a5\u683c", new Object[0]);
        }
    }
}

