/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.v3.client;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.third.weixin.wxpay.util.FeignUtil;
import com.mini.framework.third.weixin.wxpay.util.cache.MemoryBeanCache;
import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateContainer;
import com.mini.framework.third.weixin.wxpay.util.decode.WxpayResponseGsonDecoder;
import com.mini.framework.third.weixin.wxpay.v3.client.ClientConfigAttach;
import com.mini.framework.third.weixin.wxpay.v3.client.ErrorResponse;
import com.mini.framework.third.weixin.wxpay.v3.client.MarketDirectFeignHttpClientDelegate;
import com.mini.framework.third.weixin.wxpay.v3.client.ParamBeanValidate;
import com.mini.framework.third.weixin.wxpay.v3.client.ResponseHeaderResolver;
import com.mini.framework.third.weixin.wxpay.v3.client.SignatureRequestInterceptor;
import com.mini.framework.third.weixin.wxpay.v3.exception.WxpayBadRequestException;
import com.mini.framework.third.weixin.wxpay.v3.exception.WxpayDailyOrderNotExistException;
import com.mini.framework.third.weixin.wxpay.v3.exception.WxpayThirdException;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.AccountResultFileResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.Html5CreatePayOrderResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.JsApiCreatePayOrderResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.TradeOrderHistoryPackage;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayCreatePayOrderRequest;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayQueryPayOrderResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayRefundPayOrderRequest;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayRefundPayOrderResponse;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.date.TimeSectionType;
import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.util.string.GsonUtil;
import feign.Contract;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonEncoder;
import feign.jaxrs.JAXRSContract;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;

@Consumes(value={"application/json"})
public interface MarketDirectFeignHttpClient {
    public static final ResponseHeaderResolver headerResolver = new ResponseHeaderResolver();
    public static final org.apache.logging.log4j.Logger logger = LogManager.getLogger(MarketDirectFeignHttpClient.class);
    public static final MemoryBeanCache<MarketDirectFeignHttpClient> defaultCache = MemoryBeanCache.createMemory(100L);

    default public void applyConfigIfRequire(ClientConfigAttach clientConfigAttach) {
        throw new ServerException("\u5b50\u7c7b\u5fc5\u987b\u5b9e\u73b0\u8fd9\u4e2a\u65b9\u6cd5", new Object[0]);
    }

    public static MarketDirectFeignHttpClient createOrFromDefaultCache(String host, String key, Supplier<WxpayMarketCertificateContainer> certificateContainerSupplier) {
        return defaultCache.get(key, () -> MarketDirectFeignHttpClient.create(host, (WxpayMarketCertificateContainer)certificateContainerSupplier.get()));
    }

    public static MarketDirectFeignHttpClient create(String host, WxpayMarketCertificateContainer certificateContainer) {
        MarketDirectFeignHttpClient client = (MarketDirectFeignHttpClient)Feign.builder().contract((Contract)new JAXRSContract()).logLevel(Logger.Level.FULL).logger(MarketDirectFeignHttpClient.logger()).requestInterceptor((RequestInterceptor)new SignatureRequestInterceptor(certificateContainer)).errorDecoder(MarketDirectFeignHttpClient.errorDecoder()).encoder(MarketDirectFeignHttpClient.encoder()).decoder((Decoder)new WxpayResponseGsonDecoder(headerResolver)).target(MarketDirectFeignHttpClient.class, host);
        return new MarketDirectFeignHttpClientDelegate(client, certificateContainer);
    }

    public static Encoder encoder() {
        return new GsonEncoder(GsonUtil.buildMilliSecondDateGson()){

            public void encode(Object object, Type bodyType, RequestTemplate template) {
                if (object instanceof ParamBeanValidate) {
                    ((ParamBeanValidate)object).beforeRequestValidate();
                }
                super.encode(object, bodyType, template);
            }
        };
    }

    public static ErrorDecoder errorDecoder() {
        return (methodKey, response) -> {
            headerResolver.resolveHeaders(response.headers());
            Optional<String> bodyOptional = FeignUtil.findResponseBody(response);
            return (Exception)bodyOptional.map(ErrorResponse::fromJson).map(errorResponse -> {
                switch (errorResponse.getStatus()) {
                    case "NO_STATEMENT_EXIST": {
                        return new WxpayDailyOrderNotExistException("\u5f53\u524d\u65f6\u95f4\u6ca1\u6709\u5bf9\u5e94\u7684\u8ba2\u5355", new Object[0]);
                    }
                    case "PARAM_ERROR": {
                        return new WxpayDailyOrderNotExistException("\u53c2\u6570\u6709\u9519\u8bef", new Object[0]);
                    }
                }
                return new WxpayBadRequestException((ErrorResponse)errorResponse, "\u5fae\u4fe1\u670d\u52a1\u7aef\u53d1\u73b0\u8bf7\u6c42\u9519\u8bef\u7801:%s,\u9519\u8bef\u4fe1\u606f:%s", errorResponse.getStatus(), errorResponse.getMessage());
            }).map(e -> e).orElseGet(() -> new WxpayThirdException("\u5fae\u4fe1\u652f\u4ed8 %s \u4e2d\u51fa\u73b0\u672a\u77e5\u5f02\u5e38:%s,%s", methodKey, response.status(), response.reason()));
        };
    }

    public static Logger logger() {
        return new Logger(){

            protected void log(String configKey, String format, Object ... args) {
                logger.log(MiniLogLevel.getFrameWorkLog(), "\u5fae\u4fe1\u652f\u4ed8v3:" + String.format(format, args));
            }
        };
    }

    default public String showCurrentHadMarketKey() {
        throw new ServerException("\u5b50\u7c7b\u5fc5\u987b\u5b9e\u73b0\u8fd9\u4e2a\u65b9\u6cd5", new Object[0]);
    }

    @GET
    @Path(value="/v3/pay/transactions/out-trade-no/{siteOrderNumber}")
    public WxpayQueryPayOrderResponse queryPayOrderBySiteOrder(@QueryParam(value="mchid") String var1, @PathParam(value="siteOrderNumber") String var2);

    @GET
    @Path(value="/v3/pay/transactions/id/{wxpayOrderNumber}")
    public WxpayQueryPayOrderResponse queryPayOrderByWxpayOrder(@QueryParam(value="mchid") String var1, @PathParam(value="wxpayOrderNumber") String var2);

    @GET
    @Path(value="/v3/pay/transactions/out-trade-no/{siteOrderNumber}/close")
    public WxpayQueryPayOrderResponse closePayOrderBySiteOrder(@QueryParam(value="mchid") String var1, @PathParam(value="siteOrderNumber") String var2);

    @POST
    @Path(value="/v3/refund/domestic/refunds")
    public WxpayRefundPayOrderResponse executeRefundPayOrder(WxpayRefundPayOrderRequest var1);

    @GET
    @Path(value="/v3/refund/domestic/refunds/{siteRefundOrderNumber}")
    public WxpayRefundPayOrderResponse queryRefundPayOrderBySiteOrder(@PathParam(value="siteRefundOrderNumber") String var1);

    @GET
    @Path(value="/v3/bill/tradebill")
    public AccountResultFileResponse queryDailyHistoryOrdersFile(@QueryParam(value="bill_date") String var1, @QueryParam(value="bill_type") String var2) throws WxpayDailyOrderNotExistException;

    @GET
    @Path(value="/{path}")
    public byte[] downloadByteArrayResultFileByTokenTypePath(@PathParam(value="path") String var1, @QueryParam(value="token") String var2);

    default public TradeOrderHistoryPackage readTradeResultContentByTokenTypePath(AccountResultFileResponse response) {
        String path = response.getPathOfResourceUrl();
        path = path.substring(1);
        byte[] fileBytes = this.downloadByteArrayResultFileByTokenTypePath(path, response.queryTokenOfResourceUrl().orElseThrow(() -> new ServerException("\u627e\u4e0d\u5230token", new Object[0])));
        String content = new String(fileBytes);
        return TradeOrderHistoryPackage.fromOriginContent(content);
    }

    default public AccountResultFileResponse queryDailyPayOrdersFile(Date dayDate) throws WxpayDailyOrderNotExistException {
        AssertUtil.assertMethodRequire((Object)dayDate, (String)"dayDate");
        MarketDirectFeignHttpClient.validateHistoryOrdersParamsDay(dayDate);
        String dayString = DateFormatUtils.format((Date)dayDate, (String)"yyyy-MM-dd");
        return this.queryDailyHistoryOrdersFile(dayString, "SUCCESS");
    }

    default public AccountResultFileResponse queryDailyRefundOrdersFile(Date dayDate) throws WxpayDailyOrderNotExistException {
        AssertUtil.assertMethodRequire((Object)dayDate, (String)"dayDate");
        MarketDirectFeignHttpClient.validateHistoryOrdersParamsDay(dayDate);
        String dayString = DateFormatUtils.format((Date)dayDate, (String)"yyyy-MM-dd");
        return this.queryDailyHistoryOrdersFile(dayString, "REFUND");
    }

    public static void validateHistoryOrdersParamsDay(Date dayDate) {
        Date now = new Date();
        Date nowDay = DateUtil.getCleanedDateUnit((TimeSectionType)TimeSectionType.day, (Date)now);
        Date minDayDate = DateUtil.addTimeUnit((TimeSectionType)TimeSectionType.day, (Date)nowDay, (int)-90);
        Date maxDayDate = DateUtil.addTimeUnit((TimeSectionType)TimeSectionType.day, (Date)nowDay, (int)-1);
        if (!minDayDate.before(dayDate)) {
            throw new WxpayThirdException("\u67e5\u8be2\u65f6\u95f4:%s\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u4ee5\u524d90\u5929:%s", dayDate.toInstant(), minDayDate.toInstant());
        }
        if (!maxDayDate.after(dayDate)) {
            throw new WxpayThirdException("\u67e5\u8be2\u65f6\u95f4:%s\u4e0d\u80fd\u8fdf\u4e8e\u5f53\u524d\u4ee5\u524d2\u5929:%s", dayDate.toInstant(), maxDayDate.toInstant());
        }
    }

    default public TradeOrderHistoryPackage queryDailyPayOrdersPackage(Date dayDate) {
        try {
            AccountResultFileResponse fileResponse = this.queryDailyPayOrdersFile(dayDate);
            return this.readTradeResultContentByTokenTypePath(fileResponse);
        }
        catch (WxpayDailyOrderNotExistException e) {
            logger.warn("\u53d1\u73b0\u4e00\u4e2a\u5f02\u5e38:\u6ca1\u6709\u627e\u5230\u5bf9\u63a5\u8ba2\u5355\u5217\u8868", (Throwable)((Object)e));
            return TradeOrderHistoryPackage.createEmpty();
        }
    }

    default public TradeOrderHistoryPackage queryDailyRefundOrdersPackage(Date dayDate) {
        try {
            AccountResultFileResponse fileResponse = this.queryDailyRefundOrdersFile(dayDate);
            return this.readTradeResultContentByTokenTypePath(fileResponse);
        }
        catch (WxpayDailyOrderNotExistException e) {
            logger.warn("\u53d1\u73b0\u4e00\u4e2a\u5f02\u5e38:\u6ca1\u6709\u627e\u5230\u5bf9\u63a5\u8ba2\u5355\u5217\u8868", (Throwable)((Object)e));
            return TradeOrderHistoryPackage.createEmpty();
        }
    }

    @POST
    @Path(value="/v3/pay/transactions/h5")
    public Html5CreatePayOrderResponse createHtml5PayOrder(WxpayCreatePayOrderRequest var1);

    @POST
    @Path(value="/v3/pay/transactions/jsapi")
    public JsApiCreatePayOrderResponse createJsApiPayOrder(WxpayCreatePayOrderRequest var1);
}

