/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.v3.client;

import com.mini.framework.third.weixin.wxpay.util.FeignUtil;
import com.mini.framework.third.weixin.wxpay.util.certificate.CertificateSignatureRequireParams;
import com.mini.framework.third.weixin.wxpay.util.certificate.HandlerAfterCertificateSignature;
import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateContainer;
import com.mini.framework.util.test.TestFileSupport;
import feign.RequestInterceptor;
import feign.RequestTemplate;

public class SignatureRequestInterceptor
implements RequestInterceptor,
TestFileSupport {
    public final WxpayMarketCertificateContainer certificate;

    public SignatureRequestInterceptor(WxpayMarketCertificateContainer certificate) {
        this.certificate = certificate;
    }

    public void apply(final RequestTemplate template) {
        String bodyString = FeignUtil.findRequestBody(template).orElse("");
        CertificateSignatureRequireParams params = new CertificateSignatureRequireParams();
        params.setApiMethod(template.request().method());
        params.setRequestBody(bodyString);
        params.setApiUrlPath(template.request().url());
        this.certificate.signatureThenFillBack(params, new HandlerAfterCertificateSignature(){

            @Override
            public void foundHeaderAuthToken(String authToken) {
                template.header("Authorization", new String[]{authToken});
            }

            @Override
            public void foundSignature(String signature) {
            }
        });
    }
}

