/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.TradeOrderHistoryRecordItem;
import com.mini.framework.util.string.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TradeOrderHistoryPackage {
    private String originContent;
    List<TradeOrderHistoryRecordItem> orders;
    private Integer payOrderItemPiece;
    private Integer payOrderMoneySum;
    private Integer refundOrderMoneySum;

    public static Integer moneyFenFromYuan(String yuan) {
        return (Integer)StringUtil.yuan2fen((String)yuan).orElseThrow(() -> new ServerException("\u8f93\u5165\u7684\u94b1\u6570\u636e\u9519\u8bef:[%s]", new Object[]{yuan}));
    }

    public static List<String> splitItemFromOriginLine(String originLine) {
        return Stream.of(originLine.split(",")).map(item -> item.contains("`") ? StringUtils.substringAfter((String)item, (String)"`") : item).collect(Collectors.toList());
    }

    public static TradeOrderHistoryPackage fromOriginContent(String originContent) {
        TradeOrderHistoryPackage instance = new TradeOrderHistoryPackage();
        List originLines = Stream.of(originContent.split("\n")).map(line -> line.contains("\r") ? StringUtils.substringBefore((String)line, (String)"\r") : line).collect(Collectors.toList());
        instance.orders = originLines.stream().skip(1L).filter(TradeOrderHistoryRecordItem::isItemOriginLine).map(TradeOrderHistoryRecordItem::fromOriginLine).collect(Collectors.toList());
        Optional lastOptional = originLines.stream().reduce((pre, next) -> next);
        String lastRecord = (String)lastOptional.orElseThrow(() -> new ServerException("TODO \u9700\u8981\u8865\u5145\u8bf4\u660e", new Object[0]));
        instance.fillSizeSumFromThis(lastRecord);
        return instance;
    }

    public static TradeOrderHistoryPackage createEmpty() {
        TradeOrderHistoryPackage instance = new TradeOrderHistoryPackage();
        instance.orders = new ArrayList<TradeOrderHistoryRecordItem>();
        instance.payOrderItemPiece = 0;
        instance.payOrderMoneySum = 0;
        instance.refundOrderMoneySum = 0;
        return instance;
    }

    public TradeOrderHistoryPackage fillSizeSumFromThis(String sizeSumLine) {
        List<String> lastItems = TradeOrderHistoryPackage.splitItemFromOriginLine(sizeSumLine);
        this.payOrderItemPiece = Integer.parseInt(lastItems.get(0));
        this.payOrderMoneySum = TradeOrderHistoryPackage.moneyFenFromYuan(lastItems.get(5));
        this.refundOrderMoneySum = TradeOrderHistoryPackage.moneyFenFromYuan(lastItems.get(6));
        return this;
    }

    public String getOriginContent() {
        return this.originContent;
    }

    public void setOriginContent(String originContent) {
        this.originContent = originContent;
    }

    public List<TradeOrderHistoryRecordItem> getOrders() {
        return this.orders;
    }

    public void setOrders(List<TradeOrderHistoryRecordItem> orders) {
        this.orders = orders;
    }

    public Integer getPayOrderItemPiece() {
        return this.payOrderItemPiece;
    }

    public void setPayOrderItemPiece(Integer payOrderItemPiece) {
        this.payOrderItemPiece = payOrderItemPiece;
    }

    public Integer getPayOrderMoneySum() {
        return this.payOrderMoneySum;
    }

    public void setPayOrderMoneySum(Integer payOrderMoneySum) {
        this.payOrderMoneySum = payOrderMoneySum;
    }

    public Integer getRefundOrderMoneySum() {
        return this.refundOrderMoneySum;
    }

    public void setRefundOrderMoneySum(Integer refundOrderMoneySum) {
        this.refundOrderMoneySum = refundOrderMoneySum;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

