/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateContainer;
import com.mini.framework.third.weixin.wxpay.v3.client.ClientConfigAttach;
import com.mini.framework.third.weixin.wxpay.v3.client.ParamBeanValidate;
import com.mini.framework.third.weixin.wxpay.v3.model.site.SiteCreatePayOrderRequest;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.Optional;

public class WxpayCreatePayOrderRequest
implements ClientConfigAttach,
ParamBeanValidate {
    @SerializedName(value="appid")
    private String appid;
    @SerializedName(value="mchid")
    private String marketKey;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="out_trade_no")
    private String siteOrderNumber;
    @SerializedName(value="time_expire")
    private String expireDate;
    @SerializedName(value="notify_url")
    private String resultPushUrl;
    @SerializedName(value="amount")
    private OrderMoney orderAmount;
    @SerializedName(value="scene_info")
    private TradeScene tradeScene;
    @SerializedName(value="attach")
    private String attach;
    @SerializedName(value="payer")
    private ClientUser payerClient;

    public WxpayCreatePayOrderRequest fillChinaAmount(int amount) {
        AssertUtil.assertNotFatalBug((amount > 0 ? 1 : 0) != 0, (String)"\u652f\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        this.orderAmount = OrderMoney.createChinaAmount(amount);
        return this;
    }

    public WxpayCreatePayOrderRequest fillDefaultScene() {
        this.tradeScene = TradeScene.createDefault();
        return this;
    }

    public WxpayCreatePayOrderRequest fillOpenid(String openid) {
        this.payerClient = ClientUser.createByOpenid(openid);
        return this;
    }

    public static WxpayCreatePayOrderRequest createHtml5OrderFrom(SiteCreatePayOrderRequest request) {
        AssertUtil.assertNotFatalBug((request.getOpenid() == null ? 1 : 0) != 0, (String)"h5\u652f\u4ed8\u4e0d\u9700\u8981openid", (Object[])new Object[0]);
        return WxpayCreatePayOrderRequest.createOrderFrom(request);
    }

    public static WxpayCreatePayOrderRequest createJsapiOrderFrom(SiteCreatePayOrderRequest request) {
        AssertUtil.assertMethodRequire((Object)request.getOpenid(), (String)"request.getOpenid()");
        return WxpayCreatePayOrderRequest.createOrderFrom(request);
    }

    private static WxpayCreatePayOrderRequest createOrderFrom(SiteCreatePayOrderRequest request) {
        WxpayCreatePayOrderRequest instance = new WxpayCreatePayOrderRequest();
        instance.marketKey = null;
        instance.appid = request.getAppid();
        instance.expireDate = request.getExpireDate().toInstant().toString();
        instance.description = request.getOrderName();
        instance.siteOrderNumber = request.getOrderNumber();
        instance.resultPushUrl = request.getResultPushUrl();
        Optional.ofNullable(request.getOpenid()).ifPresent(instance::fillOpenid);
        instance.fillDefaultScene();
        instance.fillChinaAmount(request.getOrderAmount());
        return instance;
    }

    @Override
    public void applyClientConfig(WxpayMarketCertificateContainer certificateContainer) {
        this.marketKey = certificateContainer.getMarketKey();
    }

    @Override
    public void beforeRequestValidate() {
        AssertUtil.assertNotFatal((this.marketKey != null ? 1 : 0) != 0, (String)"marketKey \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertNotFatal((this.appid != null ? 1 : 0) != 0, (String)"appid \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMarketKey() {
        return this.marketKey;
    }

    public void setMarketKey(String marketKey) {
        this.marketKey = marketKey;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSiteOrderNumber() {
        return this.siteOrderNumber;
    }

    public void setSiteOrderNumber(String siteOrderNumber) {
        this.siteOrderNumber = siteOrderNumber;
    }

    public String getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(String expireDate) {
        this.expireDate = expireDate;
    }

    public String getResultPushUrl() {
        return this.resultPushUrl;
    }

    public void setResultPushUrl(String resultPushUrl) {
        this.resultPushUrl = resultPushUrl;
    }

    public OrderMoney getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(OrderMoney orderAmount) {
        this.orderAmount = orderAmount;
    }

    public String getAttach() {
        return this.attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public TradeScene getTradeScene() {
        return this.tradeScene;
    }

    public void setTradeScene(TradeScene tradeScene) {
        this.tradeScene = tradeScene;
    }

    public ClientUser getPayerClient() {
        return this.payerClient;
    }

    public void setPayerClient(ClientUser payerClient) {
        this.payerClient = payerClient;
    }

    public static class OrderMoney {
        @SerializedName(value="total")
        private Integer amount;
        @SerializedName(value="currency")
        private String currency;

        public static OrderMoney createChinaAmount(int amount) {
            OrderMoney instance = new OrderMoney();
            instance.amount = amount;
            instance.currency = "CNY";
            return instance;
        }

        public Integer getAmount() {
            return this.amount;
        }

        public void setAmount(Integer amount) {
            this.amount = amount;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }
    }

    public static class TradeScene {
        @SerializedName(value="payer_client_ip")
        private String payerClientIp;

        public String getPayerClientIp() {
            return this.payerClientIp;
        }

        public void setPayerClientIp(String payerClientIp) {
            this.payerClientIp = payerClientIp;
        }

        public static TradeScene createDefault() {
            TradeScene instance = new TradeScene();
            instance.payerClientIp = "192.168.0.0";
            return instance;
        }
    }

    public static class ClientUser {
        @SerializedName(value="openid")
        private String openid;

        public static ClientUser createByOpenid(String openid) {
            AssertUtil.assertMethodRequire((Object)openid, (String)"openid");
            ClientUser instance = new ClientUser();
            instance.openid = openid;
            return instance;
        }

        public String getOpenid() {
            return this.openid;
        }

        public void setOpenid(String openid) {
            this.openid = openid;
        }
    }
}

