package com.mini.framework.third.aliyun.model.content.type;

import java.util.Comparator;

/**
 * <pre>
 * 建议用户执行的操作，取值范围：
 * pass：文本正常
 * review：需要人工审核
 * block：文本违规，可以直接删除或者做限制处理
 * </pre>
 * 
 * @author jayheo
 *
 */
public enum Suggestion {
	pass(0), review(1), block(2)
	;
	private int index;

	private Suggestion(int index) {
		this.index = index;
	}

	public int getIndex() {
		return index;
	}
	
	public boolean pass(){
		return this.equals(pass);
	}
	
	public static Comparator<Suggestion> seriousSorter(){
		return Comparator.comparing(Suggestion::getIndex);
	}
	
}
