package com.mini.framework.third.weixin.console.server.model.template;

import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;

public class Document {

	@SerializedName("id")
	private String key;

	@SerializedName("title")
	private String title;

	@SerializedName("class1")
	private String firstIndustryName;

	@SerializedName("class2")
	private String secondIndustryName;

	@SerializedName("person_used")
	private Integer useCount;

	@SerializedName("invalid")
	private Integer invalid;

	@SerializedName("reason")
	private String statusReason;

	@SerializedName("modify_time")
	private String updateDate;

	@SerializedName("content")
	private String template;

	@SerializedName("example")
	private String example;

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getFirstIndustryName() {
		return firstIndustryName;
	}

	public void setFirstIndustryName(String firstIndustryName) {
		this.firstIndustryName = firstIndustryName;
	}

	public String getSecondIndustryName() {
		return secondIndustryName;
	}

	public void setSecondIndustryName(String secondIndustryName) {
		this.secondIndustryName = secondIndustryName;
	}

	public Integer getUseCount() {
		return useCount;
	}

	public void setUseCount(Integer useCount) {
		this.useCount = useCount;
	}

	public Integer getInvalid() {
		return invalid;
	}

	public void setInvalid(Integer invalid) {
		this.invalid = invalid;
	}

	public String getStatusReason() {
		return statusReason;
	}

	public void setStatusReason(String statusReason) {
		this.statusReason = statusReason;
	}

	public String getUpdateDate() {
		return updateDate;
	}

	public void setUpdateDate(String updateDate) {
		this.updateDate = updateDate;
	}

	public String getTemplate() {
		return template;
	}

	public void setTemplate(String template) {
		this.template = template;
	}

	public String getExample() {
		return example;
	}

	public void setExample(String example) {
		this.example = example;
	}
	
	public boolean beforeThan(Document other){
		if(other.updateDate!=null){
			return updateDate==null || other.updateDate.compareTo(updateDate)>0;
		}else{
			return false;
		}
		
		
	}
	
	public boolean matchKey(String key){
		return Objects.equals(this.key, key);
	}
	
	public static Document fromJson(String json){
		return new Gson().fromJson(json, Document.class);
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	public boolean theSameStatusWithSimple(Document documentSimple) {
		return simpleKeyForUpdate().equals(documentSimple.simpleKeyForUpdate());
	}
	
	public boolean ifRequireResyncFromSimple(Document documentSimple){
		return beforeThan(documentSimple) || !theSameStatusWithSimple(documentSimple);
	}
	
	public String simpleKeyForUpdate(){
		String key = Stream.of( this.key,title,firstIndustryName,secondIndustryName,useStatus()).map(String::valueOf).collect(Collectors.joining("-"));
		return key;
	}
	
	public boolean useStatus(){
		return invalid==null||invalid!=1;
	}

}
