package com.mini.framework.third.weixin.mapp.model;

import com.mini.framework.util.params.MapParams;


/**
 * http://wiki.xxggpt.com/docs/wykjdev/mapp-awake
 * @author jayheo
 *
 */
public class MappCommandAwakeParams extends MapParams{

	private String pagePath;
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -1075290383840502224L;

	
	public static MappCommandAwakeParams build(String pagePath){
		MappCommandAwakeParams ins = new MappCommandAwakeParams();
		ins.pagePath = pagePath;
		return ins;
	}
	
	/**
	 * 如果出现chat进入与对应用户的私聊天界面。要注意，如果chat的值没有或者chat<=0就进入聊天列表。
	 * @return
	 */
	public MappCommandAwakeParams chat(){
		return chat(null);
	}
	
	public MappCommandAwakeParams chat(Object value){
		if(value==null){
			value = "";
		}
		param("chat", value);
		return this;
	}
	
	/**
	 * 如果出现user进入对应用户的首页(这个用户的名片，如果这个用户没有名片的话，就是程序的首页)
	 * @return
	 */
	public MappCommandAwakeParams user(Object userId){
		param("user", userId);
		return this;
	}
	
	public String paramsApplyPagePath() {
		String params = super.toUrlParams();
		return  pagePath  +(params==null || params.length()==0?"":"?") + super.toUrlParams();
	}
	
}
