package com.mini.framework.third.weixin.notice.server.model.resp;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("xml")
public class MappPageNotice extends WeixinNotice {
	
	/**
	 * 当前发送的小程序的应用id
	 */
	@XStreamAlias("AppId")
	private String mappAppid;
	
	
	@XStreamAlias("Title")
	private String mappTitle;

	/**
	 * 当前发送的小程序的路径
	 */
	@XStreamAlias("PagePath")
	private String mappPage;
	
	
	/**
	 * 小程序窗口的图片地址
	 */
	@XStreamAlias("ThumbUrl")
	private String framePhoto;
	
	/**
	 * 小程序窗口的图片媒体id
	 * 这个可能是图片放在微信服务器上的id
	 */
	@XStreamAlias("ThumbMediaId")
	private String framePhotoMediaId;

	public String getMappAppid() {
		return mappAppid;
	}

	public void setMappAppid(String mappAppid) {
		this.mappAppid = mappAppid;
	}

	public String getMappPage() {
		return mappPage;
	}

	public void setMappPage(String mappPage) {
		this.mappPage = mappPage;
	}

	public String getFramePhoto() {
		return framePhoto;
	}

	public void setFramePhoto(String framePhoto) {
		this.framePhoto = framePhoto;
	}

	public String getFramePhotoMediaId() {
		return framePhotoMediaId;
	}

	public void setFramePhotoMediaId(String framePhotoMediaId) {
		this.framePhotoMediaId = framePhotoMediaId;
	}

	public String getMappTitle() {
		return mappTitle;
	}

	public void setMappTitle(String mappTitle) {
		this.mappTitle = mappTitle;
	}
	
	
}
