package com.mini.framework.third.weixin.notice.server.model.resp;

import com.thoughtworks.xstream.annotations.XStreamAlias;


/*
https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140453
<xml><ToUserName>< ![CDATA[toUser] ]></ToUserName><FromUserName>< ![CDATA[fromUser] ]></FromUserName><CreateTime>1357290913</CreateTime><MsgType>< ![CDATA[shortvideo] ]></MsgType><MediaId>< ![CDATA[media_id] ]></MediaId><ThumbMediaId>< ![CDATA[thumb_media_id] ]></ThumbMediaId><MsgId>1234567890123456</MsgId></xml>

参数	描述
ToUserName	开发者微信号
FromUserName	发送方帐号（一个OpenID）
CreateTime	消息创建时间 （整型）
MsgType	视频为video
MediaId	视频消息媒体id，可以调用多媒体文件下载接口拉取数据。
ThumbMediaId	视频消息缩略图的媒体id，可以调用多媒体文件下载接口拉取数据。
MsgId	消息id，64位整型

*/
/**
 * 微信小视频的通知
 * @author jayheo
 *
 */
@XStreamAlias("xml")
public class ShortvideoNotice extends WeixinNotice{
	@XStreamAlias("ThumbMediaId")
	private String thumbMediaId;
	
	@XStreamAlias("MediaId")
	private String mediaId;


	
	public String getThumbMediaId() {
		return thumbMediaId;
	}

	public void setThumbMediaId(String thumbMediaId) {
		this.thumbMediaId = thumbMediaId;
	}

	public String getMediaId() {
		return mediaId;
	}

	public void setMediaId(String mediaId) {
		this.mediaId = mediaId;
	}
}
