package com.mini.framework.third.weixin.server.comm;

import com.mini.framework.util.asserts.AssertUtil;

public class SceneQrcodeRequest implements ReqSerializable {

	// action_name QR_LIMIT_SCENE or QR_LIMIT_STR_SCENE
	// action_name 二维码类型，QR_SCENE为临时的整型参数值，
	// QR_STR_SCENE为临时的字符串参数值，QR_LIMIT_SCENE为永久的整型参数值，QR_LIMIT_STR_SCENE为永久的字符串参数值
	private String action;

	// expire_seconds 该二维码有效时间，以秒为单位。 最大不超过2592000（即30天），此字段如果不填，则默认有效期为30秒。
	private Integer expire;

	// scene_str 场景值ID（字符串形式的ID），字符串类型，长度限制为1到64
	private String qrKey;

	// ex {'action_name': 'QR_LIMIT_STR_SCENE', 'action_info': {'scene':
	// {'scene_str': 'test'}}}
	//永久二维码报文
	private String messageTemplate = "{'action_name': '%s', 'action_info': {'scene': {'scene_str': '%s'}}}";
	//private String messageTemplate = "{'action_name': '${action}', 'action_info': {'scene': {'scene_str': '${qrKey}'}}}";
	
	//临时二维码报文
	private String limitMessageTemplate = "{'expire_seconds': %s,'action_name': '%s', 'action_info': {'scene': {'scene_str': '%s'}}}";
	//private String limitMessageTemplate = "{'expire_seconds': ${expire},'action_name': '${action}', 'action_info': {'scene': {'scene_str': '${qrKey}'}}}";
	
	public static SceneQrcodeRequest create(String qrKey,boolean expire){
		if(expire){
			return  new SceneQrcodeRequest(2592000, qrKey);
		}else{
			return  new SceneQrcodeRequest(qrKey);
		}
	}
	
	private SceneQrcodeRequest(int expire, String qrKey) {
		super();
		AssertUtil.assertSupport(expire<=2592000, "临时二维码有效期不能超过30天");
		this.expire = expire;
		this.qrKey = qrKey;
		this.action = "QR_STR_SCENE";
	}
	
	private SceneQrcodeRequest(String qrKey) {
		super();
		this.qrKey = qrKey;
		this.action = "QR_LIMIT_STR_SCENE" ;
	}

	@Override
	public String serialize() {
		if(expire==null){
			return String.format(messageTemplate,action, qrKey).replaceAll("'", "\"");
		}else{
			return String.format(limitMessageTemplate,expire,action, qrKey).replaceAll("'", "\"");
		}
	}

	public String getAction() {
		return action;
	}

	public Integer getExpire() {
		return expire;
	}

	public String getQrKey() {
		return qrKey;
	}

	public String getMessageTemplate() {
		return messageTemplate;
	}

	public String getLimitMessageTemplate() {
		return limitMessageTemplate;
	}
	
}
