package com.mini.framework.third.weixin.wxpay.type;

/**
 * 微信支付的渠道类型
 * 对应微信文档上的 交易类型trade_type
 * https://pay.weixin.qq.com/wiki/doc/apiv3/index.shtml
 * @author jayheo
 */

public enum WxpayChannelType {


    /**
     * JSAPI--公众号支付、小程序支付
     */
    pay1("JSAPI"),
    /**
     * APP--APP支付
     */
    pay2("APP"),
    /**
     * NATIVE--原生扫码支付
     */
    pay3("NATIVE"),
    pay4("WAP"),

    /**
     * MWEB--WAP支付
     */
    pay5("MWEB"),

    /**
     * MICROPAY--刷卡支付,刷卡支付有单独的支付接口，不调用统一下单接口
     */
    pay6("MICROPAY"),
    ;

    private final String weixinKey;

    WxpayChannelType(String weixinKey) {
        this.weixinKey = weixinKey;
    }
}
