package com.mini.framework.third.weixin.notice.server.model.resp;

import com.mini.framework.core.status.Status.Server;
import com.mini.framework.util.asserts.AssertUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;


/*
 * 模板消息发送的结果
 * 报文示例
<xml><ToUserName><![CDATA[gh_5f8a403a7e91]]></ToUserName>
<FromUserName><![CDATA[oDmGI1T65oFagp_oWWNz-KMOfaZE]]></FromUserName>
<CreateTime>1540480423</CreateTime>
<MsgType><![CDATA[event]]></MsgType>
<Event><![CDATA[TEMPLATESENDJOBFINISH]]></Event>
<MsgID>518217200327557120</MsgID>
<Status><![CDATA[success]]></Status>
</xml>
 * */

@XStreamAlias("xml")
public class EventTemplateResultNotice extends EventNotice{
	/**
	 * 消息id
	 */
	@XStreamAlias("MsgID")
	private String messageId;
	
	/**
	 * 发送状态
	 */
	@XStreamAlias("Status")
	private String status;

	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}
	
	public boolean ifSuccess(){
		return "success".equals(status);
	}
	
	/**
	 * 没有成功的原因
	 * @return
	 */
	public String notSuccessCause(){
		AssertUtil.assertNotFatalProgramConfig(!ifSuccess(),Server.programConfigJava, "只有失败了才能调用这个方法");
		return String.format("微信通知过来的报文不是:[success]而是:[%s]", status);
	}
}
