package com.mini.framework.third.weixin.server.comm;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;

import java.util.Date;

public class TicketResponse extends AbstractResponse {

	@SerializedName("ticket")
	private String ticket;


	/**
	 * 这里的时间单位是秒钟。
	 */
	@SerializedName("expires_in")
	private Integer expire;


	/**
	 * 得到过期的时间
	 * @param createDate 因为，这个时间是创建的时候为准，所以要求使用者自己传入创建时间，保证正确性
	 * @return 过期的时间
	 */
	public Date summaryExpireDate(Date createDate){
		AssertUtil.simpleAssertByStatus(expire!=null, Status.Third.wxRespForm, "微信的响应格式错误");
		return new Date(createDate.getTime() + expire * 1000L);
	}


	public String getTicket() {
		return ticket;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	public Integer getExpire() {
		return expire;
	}

	public void setExpire(Integer expire) {
		this.expire = expire;
	}

}
