package com.mini.framework.third.weixin.server.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.annotations.SerializedName;

/**
 * @author jayheo
 * 微信的消息模板
 */
public class MessageTemplate {
	@SerializedName("template_id")
	private String templateId;

	@SerializedName("title")
	private String title;

	@SerializedName("primary_industry")
	private String firstIndustry;

	@SerializedName("deputy_industry")
	private String secondsIndustry;

	@SerializedName("content")
	private String content;

	@SerializedName("example")
	private String example;

	public String getTemplateId() {
		return templateId;
	}

	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getFirstIndustry() {
		return firstIndustry;
	}

	public void setFirstIndustry(String firstIndustry) {
		this.firstIndustry = firstIndustry;
	}

	public String getSecondsIndustry() {
		return secondsIndustry;
	}

	public void setSecondsIndustry(String secondsIndustry) {
		this.secondsIndustry = secondsIndustry;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getExample() {
		return example;
	}

	public void setExample(String example) {
		this.example = example;
	}
	
	/**
	 *<pre>
	 *下面是一个失效的举例。
	 * {
"template_id": "O_fG2d9IKmOu040rkKkbMeBYUi0Bm00PHvZEYGD1eiw",
"title": "订阅模板消息",
"primary_industry": "",
"deputy_industry": "",
"content": "{{content.DATA}}",
"example": ""
}
	 * 目前判断条件是第一第二分类都不是空说明是有效的
</pre>
	 * 
	 * @return
	 */
	public boolean isVaild(){
		return !StringUtils.isAnyBlank(firstIndustry,secondsIndustry);
	}
	
	public String getIndustry(){
		return String.format("%s - %s", firstIndustry,secondsIndustry);
	}
	
	public boolean matchTemplateId(String templateId){
		return templateId.equals(this.templateId);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
}
