package com.mini.framework.third.weixin.wxpay.util.cache;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

/**
 * 内存中实例的缓存。
 * TODO 应该弄到 util中去。
 * TODO 应该严格限制一下使用的范围，占用内存不能太大，使用数量不能太多。
 * TODO 所有的类名方法名应该要重构。
 * @author jayheo
 */
public class MemoryBeanCache<B> {

    /**
     * 过期的秒钟数
     */
    private final Long expireSeconds;

    private final Map<String ,BeanExpireHolder<B>> beanCache = new ConcurrentHashMap<>();

    private MemoryBeanCache(Long expireSeconds) {
        this.expireSeconds = expireSeconds;
    }


    public B get(BeanKey keyGetter, Supplier<B> beanSupplier){
        return get(keyGetter.showBeanFeatureKey(),beanSupplier);
    }

    public B get(String key, Supplier<B> beanSupplier){
        Optional<B> cacheBeanOptional = Optional.ofNullable(beanCache.get(key))
                .filter(BeanExpireHolder::ifNotNowExpire)
                .map(BeanExpireHolder::getBean);
        return cacheBeanOptional.orElseGet(()->{
            B newBean = beanSupplier.get();
            beanCache.put(key,new BeanExpireHolder<>(expireSeconds,newBean));
            return newBean;
        });
    }


    public static <SB> MemoryBeanCache<SB> createMemory(long expireSeconds){
        return new MemoryBeanCache<>(expireSeconds);
    }

}
