/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.cl253;

import com.mini.framework.third.cl253.comm.SendSmsCommRequest;
import com.mini.framework.third.cl253.comm.SendSmsCommResponse;
import com.mini.framework.third.cl253.model.SendSmsRequest;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.http.SimpleHttpUtil;
import com.mini.framework.util.string.GsonUtil;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClMsgClient {
    private static Logger logger = LogManager.getLogger(ClMsgClient.class);
    private static final String clServer = "http://smssh1.253.com";

    public static String send(String account, String passwd, SendSmsRequest smsRequest) {
        AssertUtil.assertMethodRequire((Object)smsRequest, (String)"smsRequest");
        AssertUtil.assertMethodRequire((Object)account, (String)"account");
        AssertUtil.assertMethodRequire((Object)passwd, (String)"passwd");
        String namespace = "/msg/send/json";
        SendSmsCommRequest commReq = smsRequest.createCommReq();
        commReq.setAccount(account);
        commReq.setPasswd(passwd);
        commReq.setRequireNotice(true);
        String traceId = DateUtil.toMilSecondsNumeric((Date)new Date()) + RandomStringUtils.randomNumeric((int)15);
        commReq.setTraceId(traceId);
        commReq.setSendDate(DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmm"));
        String commReqBody = GsonUtil.buildMilliSecondDateGson().toJson((Object)commReq);
        logger.info("\u751f\u6210\u4e86\u77ed\u4fe1\u8ddf\u8e2aid:[{}]", (Object)traceId);
        String respBody = SimpleHttpUtil.simplePost((String)(clServer + namespace), (String)commReqBody);
        SendSmsCommResponse resp = (SendSmsCommResponse)GsonUtil.buildMilliSecondDateGson().fromJson(respBody, SendSmsCommResponse.class);
        resp.handleResp();
        return traceId;
    }

    public static void batchCommandSend(String account, String passwd, List<String> commands) {
        ClMsgClient.batchSend(account, passwd, commands.stream().map(command -> SendSmsRequest.fromCommand(command)).collect(Collectors.toList()).toArray(new SendSmsRequest[0]));
    }

    public static void batchSend(String account, String passwd, SendSmsRequest ... smsRequests) {
        for (SendSmsRequest smsRequest : smsRequests) {
            ClMsgClient.send(account, passwd, smsRequest);
        }
    }
}

