/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.express.model;

import com.mini.framework.model.flag.EnumTypeShower;
import com.mini.framework.util.function.PredicateSpread;
import com.mini.framework.util.string.RegexUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public enum ExpressTransportStage implements EnumTypeShower<ExpressTransportStage>
{
    sendBack("\u9000\u56de", 10, new int[]{6}, new String[0]),
    sendBackSign("\u9000\u56de", 10, new int[]{4}, new String[0]),
    turnOther("\u8f6c\u6295\u5176\u5b83\u7684", 9, new int[]{7}, new String[0]),
    unknown("\u7591\u96be\u4f4d\u7f6e", 8, new int[]{2}, "\u7591\u96be"),
    received("\u5df2\u7b7e\u6536", 5, new int[]{3}, "\u5df2\u7b7e\u6536", "\u4ee3\u7b7e\u6536"),
    requireTake("\u5f85\u53d6\u4ef6", 4, new int[0], "\u8bf7\u53ca\u65f6\u53d6\u4ef6"),
    deliver("\u6d3e\u9001\u4e2d", 3, new int[]{5}, "\u6d3e\u9001", "\u6d3e\u4ef6"),
    progress("\u8fd0\u8f93\u4e2d", 2, new int[]{0}, "\u5df2\u53d1\u5f80", "\u5df2\u5230\u8fbe", "\u79bb\u5f00", "\u4e2d\u8f6c\u90e8"),
    activation("\u5df2\u63fd\u4ef6", 1, new int[]{1}, "\u5df2\u6536\u4ef6", "\u5df2\u63fd\u6536", "\u5df2\u63fd\u4ef6");

    private String[] guessRegexs;
    private String title;
    private int[] kuaidi100Codes;
    private int index;

    public String[] guessRegexs() {
        return this.guessRegexs;
    }

    public int index() {
        return this.index;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int[] getKuaidi100Codes() {
        return this.kuaidi100Codes;
    }

    public void setKuaidi100Codes(int[] kuaidi100Codes) {
        this.kuaidi100Codes = kuaidi100Codes;
    }

    private static Comparator<ExpressTransportStage> guessMatchSorter() {
        return Comparator.comparing(ExpressTransportStage::index);
    }

    private ExpressTransportStage(String title, int index, int[] kuaidi100Codes, String ... guessRegexs) {
        this.guessRegexs = guessRegexs;
        this.kuaidi100Codes = kuaidi100Codes;
        this.title = title;
        this.index = index;
    }

    public boolean guessMatch(String context) {
        if (context != null) {
            return Stream.of(this.guessRegexs).anyMatch(gr -> RegexUtil.getMatch((String)gr, (String)context) != null);
        }
        return false;
    }

    public static Optional<ExpressTransportStage> guessMatchOne(String context) {
        return Stream.of(ExpressTransportStage.values()).sorted(ExpressTransportStage.guessMatchSorter()).filter((Predicate<ExpressTransportStage>)PredicateSpread.applySecondParam((Object)context, ExpressTransportStage::guessMatch)).findFirst();
    }

    public void fillFieldToMap(Map<String, Object> map) {
        map.put("title", this.title);
        map.put("guessRegexs", this.guessRegexs);
        map.put("index", this.index);
    }

    public boolean matchKudidi100Code(int code) {
        return IntStream.of(this.kuaidi100Codes).anyMatch(kuaidiCode -> kuaidiCode == code);
    }

    public static Optional<ExpressTransportStage> fromKuaidi100Code(int code) {
        return Stream.of(ExpressTransportStage.values()).filter(stage -> stage.matchKudidi100Code(code)).findFirst();
    }
}

