/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.client;

import com.mini.framework.third.weixin.server.comm.AccessTokenResponse;
import com.mini.framework.third.weixin.server.comm.DefaultMenuResonpse;
import com.mini.framework.third.weixin.server.comm.OpenidListResponse;
import com.mini.framework.third.weixin.server.comm.SceneQrcodeRequest;
import com.mini.framework.third.weixin.server.comm.SceneQrcodeResponse;
import com.mini.framework.third.weixin.server.comm.TemplateListResponse;
import com.mini.framework.third.weixin.server.comm.TicketResponse;
import com.mini.framework.third.weixin.server.model.ServerJsapiTicketResponse;
import com.mini.framework.third.weixin.server.model.WeixinBaseUserDetail;
import com.mini.framework.third.weixin.server.model.WeixinServerUserDetail;
import com.mini.framework.third.weixin.server.model.WeixinWebAuthTokenResp;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface WeixinServerAccountSdk {
    public static final String serverAccountSdkPackage = "com.mini.framework.third.weixin.server";
    public static final String redisServerTokenLock = "server:global:cache:site:weixin:server:token";

    @PostMapping(value={"/qrcode/create?access_token=11"})
    public SceneQrcodeResponse createSceneQrcode(@RequestBody SceneQrcodeRequest var1);

    @GetMapping(value={"/token?grant_type=client_credential&appid=%s&secret=%s"})
    public AccessTokenResponse createAccessToken();

    @GetMapping(value={"/user/get?access_token=%s&next_openid=%s"})
    public OpenidListResponse querySubscribeOpenidList(String var1);

    @GetMapping(value={"/user/info?access_token=%s&openid=%s&lang=zh_CN"})
    public WeixinServerUserDetail queryUserDetailByOpenid(String var1);

    default public WeixinServerUserDetail queryAuthByCode(String code) {
        return this.queryAuthByCode(code, c -> {});
    }

    @GetMapping(value={"/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code"})
    public WeixinServerUserDetail queryAuthByCode(String var1, Consumer<WeixinWebAuthTokenResp> var2);

    @GetMapping(value={"/sns/userinfo"})
    public WeixinBaseUserDetail queryUserDetailByUserAccessToken(String var1, String var2);

    @PostMapping(value={"/message/custom/send?access_token=%s"})
    public void sendTextMsg(String var1, String var2);

    @GetMapping(value={"/ticket/getticket?access_token=%s&type=jsapi"})
    default public String createJsapiTicket() {
        TicketResponse ticketResp = this.createJsapiTicketResponse();
        return ticketResp.getTicket();
    }

    @GetMapping(value={"/ticket/getticket?access_token=%s&type=jsapi"})
    public TicketResponse createJsapiTicketResponse();

    default public ServerJsapiTicketResponse createJsapiTicket(String url, String appid) {
        String ticket = this.createJsapiTicket();
        ServerJsapiTicketResponse ticketResp = new ServerJsapiTicketResponse(url, ticket, appid);
        ticketResp.sign();
        return ticketResp;
    }

    @PostMapping(value={"/message/template/send?access_token=%s"})
    public String sendTempateMsg(String var1);

    @PostMapping(value={"/template/api_add_template?access_token=%s"})
    public String createMsgTempate(String var1);

    @GetMapping(value={"/template/get_all_private_template?access_token=%s"})
    public TemplateListResponse queryExistTemplateList();

    @PostMapping(value={"/template/del_private_template?access_token=%s"})
    public void deleteTemplateResponse(String var1);

    @GetMapping(value={"/template/get_industry?access_token=%s"})
    public String queryTemplateIndustry();

    public Optional<String> currentRunnableServerAppid();

    @GetMapping(value={"/get_current_selfmenu_info?access_token=%s"})
    public DefaultMenuResonpse getServerDefaultMenu();

    @PostMapping(value={"/menu/create?access_token=%s"})
    public void setServerDefaultMenu(String var1);
}

