/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.client;

import com.google.gson.Gson;
import com.mini.framework.third.weixin.WeixinAppidType;
import com.mini.framework.third.weixin.server.client.WeixinServerAccountSdk;
import com.mini.framework.third.weixin.server.comm.AbstractResponse;
import com.mini.framework.third.weixin.server.comm.AccessTokenResponse;
import com.mini.framework.third.weixin.server.comm.CreateTemplateResponse;
import com.mini.framework.third.weixin.server.comm.DefaultMenuResonpse;
import com.mini.framework.third.weixin.server.comm.OpenidListResponse;
import com.mini.framework.third.weixin.server.comm.SceneQrcodeRequest;
import com.mini.framework.third.weixin.server.comm.SceneQrcodeResponse;
import com.mini.framework.third.weixin.server.comm.SimpleResponse;
import com.mini.framework.third.weixin.server.comm.TempMsgResponse;
import com.mini.framework.third.weixin.server.comm.TemplateListResponse;
import com.mini.framework.third.weixin.server.comm.TicketResponse;
import com.mini.framework.third.weixin.server.model.ServerJsapiTicketResponse;
import com.mini.framework.third.weixin.server.model.WeixinServerAccountAccess;
import com.mini.framework.third.weixin.server.model.WeixinServerUserDetail;
import com.mini.framework.third.weixin.server.model.WeixinWebAuthTokenResp;
import com.mini.framework.third.weixin.server.provider.WeixinServerAccessProvider;
import com.mini.framework.third.weixin.server.provider.WeixinSiteTokenProvider;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.SimpleHttpUtil;
import com.mini.framework.util.string.GsonUtil;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WeixinServerSdkSimpleImpl
implements WeixinServerAccountSdk {
    public static final String defaultWeixinApiHost = "https://api.weixin.qq.com";
    @Value(value="${weixin.open.api.url:https://api.weixin.qq.com}")
    private String server;
    private String moudle = "/cgi-bin";
    @Autowired
    private WeixinSiteTokenProvider siteTokenProvider;
    @Autowired
    private WeixinServerAccessProvider weixinServerAccessProvider;
    private Logger logger = LogManager.getLogger(WeixinServerSdkSimpleImpl.class);

    public WeixinSiteTokenProvider getSiteTokenProvider() {
        return this.siteTokenProvider;
    }

    public void setSiteTokenProvider(WeixinSiteTokenProvider siteTokenProvider) {
        this.siteTokenProvider = siteTokenProvider;
    }

    public WeixinServerAccessProvider getWeixinServerAccessProvider() {
        return this.weixinServerAccessProvider;
    }

    public void setWeixinServerAccessProvider(WeixinServerAccessProvider weixinServerAccessProvider) {
        this.weixinServerAccessProvider = weixinServerAccessProvider;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    private String currToken() {
        return this.siteTokenProvider.currSiteToken(WeixinAppidType.server);
    }

    private String getHadServer() {
        AssertUtil.assertNotFatalBug((this.server != null ? 1 : 0) != 0, (String)"\u5fae\u4fe1\u670d\u52a1\u53f7sdk\u4e2d\u53c2\u6570server\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.server;
    }

    @Override
    public SceneQrcodeResponse createSceneQrcode(SceneQrcodeRequest req) {
        String token = this.currToken();
        AssertUtil.assertNotFatal((token != null ? 1 : 0) != 0, (String)"\u5fae\u4fe1token\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String action = "/qrcode/create?access_token=" + this.currToken();
        String url = this.getHadServer() + this.moudle + action;
        String reqBody = req.serialize();
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        SceneQrcodeResponse resp = (SceneQrcodeResponse)new Gson().fromJson(respStr, SceneQrcodeResponse.class);
        resp.handle("reqBody:%s", reqBody);
        return resp;
    }

    @Override
    public AccessTokenResponse createAccessToken() {
        String action = "/token?grant_type=client_credential&appid=%s&secret=%s";
        WeixinServerAccountAccess access = this.weixinServerAccessProvider.serverProvide();
        String appid = access.getAppid();
        String secret = access.getSecret();
        String url = this.getHadServer() + this.moudle + String.format(action, appid, secret);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        AccessTokenResponse resp = (AccessTokenResponse)new Gson().fromJson(respStr, AccessTokenResponse.class);
        resp.handle("url:%s", url);
        return resp;
    }

    @Override
    public WeixinServerUserDetail queryUserDetailByOpenid(String openid) {
        String action = "/user/info?access_token=%s&openid=%s&lang=zh_CN";
        String token = this.currToken();
        String url = this.getHadServer() + this.moudle + String.format(action, token, openid);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        WeixinServerUserDetail resp = WeixinServerUserDetail.fromJson(WeixinServerUserDetail.class, respStr);
        resp.handle("url:%s", url);
        return resp;
    }

    @Override
    public WeixinServerUserDetail queryAuthByCode(String code, Consumer<WeixinWebAuthTokenResp> tokenRespConsumer) {
        String action = "/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
        WeixinServerAccountAccess access = this.weixinServerAccessProvider.serverProvide();
        String appid = access.getAppid();
        String secret = access.getSecret();
        String url = this.getHadServer() + String.format(action, appid, secret, code);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        WeixinWebAuthTokenResp tokenResp = (WeixinWebAuthTokenResp)GsonUtil.buildSecondDateGson().fromJson(respStr, WeixinWebAuthTokenResp.class);
        tokenResp.handle("url:%s", url);
        tokenRespConsumer.accept(tokenResp);
        if (tokenResp.haveUserInfoModel()) {
            return this.queryUserDetailByUserAccessToken(tokenResp.getAccessToken(), tokenResp.getOpenId());
        }
        WeixinServerUserDetail simple = new WeixinServerUserDetail();
        simple.setOpenId(tokenResp.getOpenId());
        return simple;
    }

    @Override
    public WeixinServerUserDetail queryUserDetailByUserAccessToken(String accessToken, String openid) {
        String action = "/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN";
        String url = this.getHadServer() + String.format(action, accessToken, openid);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        WeixinServerUserDetail resp = WeixinServerUserDetail.fromJson(WeixinServerUserDetail.class, respStr);
        resp.handle("url:%s", url);
        return resp;
    }

    @Override
    public void sendTextMsg(String openId, String content) {
        String token = this.currToken();
        String action = "/message/custom/send?access_token=%s";
        String bodyTemp = "{\"touser\": \"%s\", \"msgtype\": \"text\", \"text\": {\"content\": \"%s\"}}";
        String body = String.format(bodyTemp, openId, content);
        String url = this.getHadServer() + this.moudle + String.format(action, token);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)body);
        SimpleResponse resp = (SimpleResponse)new Gson().fromJson(respStr, SimpleResponse.class);
        resp.handle("reqBody:%s", body);
    }

    @Override
    public TicketResponse createJsapiTicketResponse() {
        String token = this.currToken();
        String action = "/ticket/getticket?access_token=%s&type=jsapi";
        String url = this.getHadServer() + this.moudle + String.format(action, token);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        TicketResponse resp = AbstractResponse.fromJson(TicketResponse.class, respStr);
        resp.handle("url:%s", url);
        return resp;
    }

    public ServerJsapiTicketResponse createJsapiTicket(String url) {
        String ticket = this.createJsapiTicket();
        WeixinServerAccountAccess access = this.weixinServerAccessProvider.serverProvide();
        String appid = access.getAppid();
        ServerJsapiTicketResponse ticketResp = new ServerJsapiTicketResponse(url, ticket, appid);
        ticketResp.sign();
        return ticketResp;
    }

    @Override
    public String sendTempateMsg(String reqBody) {
        AssertUtil.assertMethodRequire((Object)reqBody, (String)"reqBody");
        String token = this.currToken();
        reqBody = reqBody.replaceAll("\n", "\\\\n");
        String action = "/message/template/send?access_token=%s";
        String url = this.getHadServer() + this.moudle + String.format(action, token);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        TempMsgResponse resp = (TempMsgResponse)new Gson().fromJson(respStr, TempMsgResponse.class);
        resp.handle("reqBody:%s", reqBody);
        return resp.getMessageId();
    }

    @Override
    public String createMsgTempate(String templateKey) {
        AssertUtil.assertMethodRequire((Object)templateKey, (String)"templateKey");
        String token = this.currToken();
        String action = "/template/api_add_template?access_token=%s";
        String url = this.getHadServer() + this.moudle + String.format(action, token);
        String reqBody = String.format("{\"template_id_short\":\"%s\"}", templateKey);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        CreateTemplateResponse resp = (CreateTemplateResponse)new Gson().fromJson(respStr, CreateTemplateResponse.class);
        resp.handle("reqBody:%s", reqBody);
        return resp.getTemplateId();
    }

    @Override
    public TemplateListResponse queryExistTemplateList() {
        String token = this.currToken();
        String action = "/template/get_all_private_template?access_token=%s";
        String url = this.getHadServer() + this.moudle + String.format(action, token);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        TemplateListResponse resp = (TemplateListResponse)new Gson().fromJson(respStr, TemplateListResponse.class);
        resp.handle("url:%s", url);
        return resp;
    }

    @Override
    public void deleteTemplateResponse(String templateId) {
        AssertUtil.assertMethodRequire((Object)templateId, (String)"templateId");
        String token = this.currToken();
        String action = "/template/del_private_template?access_token=%s";
        String url = this.getHadServer() + this.moudle + String.format(action, token);
        String reqBody = String.format("{\"template_id\":\"%s\"}", templateId);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        SimpleResponse resp = (SimpleResponse)new Gson().fromJson(respStr, SimpleResponse.class);
        resp.handle("reqBody:%s", reqBody);
    }

    @Override
    public String queryTemplateIndustry() {
        String token = this.currToken();
        String action = "/template/get_industry?access_token=%s";
        String url = this.getHadServer() + this.moudle + String.format(action, token);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        SimpleResponse resp = (SimpleResponse)new Gson().fromJson(respStr, SimpleResponse.class);
        resp.handle("url:%s", url);
        return respStr;
    }

    @Override
    public OpenidListResponse querySubscribeOpenidList(String offset) {
        String token = this.currToken();
        String action = "/user/get?access_token=%s&next_openid=%s";
        String url = this.getHadServer() + this.moudle + String.format(action, token, offset == null ? "" : offset);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        OpenidListResponse resp = (OpenidListResponse)new Gson().fromJson(respStr, OpenidListResponse.class);
        resp.handle("url:%s", url);
        return resp;
    }

    @Override
    public DefaultMenuResonpse getServerDefaultMenu() {
        String token = this.currToken();
        String action = "/get_current_selfmenu_info?access_token=%s";
        String url = this.getHadServer() + this.moudle + String.format(action, token);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        SimpleResponse resp = (SimpleResponse)new Gson().fromJson(respStr, SimpleResponse.class);
        resp.handle("url:%s", url);
        return DefaultMenuResonpse.fromJson(respStr);
    }

    @Override
    public void setServerDefaultMenu(String reqJson) {
        this.logger.info("\u4fee\u6539\u5fae\u4fe1\u670d\u52a1\u53f7\u9ed8\u8ba4\u83dc\u5355\u62a5\u6587:{}", (Object)reqJson);
        String token = this.currToken();
        String action = "/menu/create?access_token=%s";
        String url = this.getHadServer() + this.moudle + String.format(action, token);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqJson);
        SimpleResponse resp = (SimpleResponse)new Gson().fromJson(respStr, SimpleResponse.class);
        resp.handle("url:%s", url);
    }

    @Override
    public Optional<String> currentRunnableServerAppid() {
        WeixinServerAccountAccess access = this.weixinServerAccessProvider.serverProvide();
        return Optional.ofNullable(access.getAppid());
    }
}

