/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.model;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.server.comm.AbstractResponse;
import com.mini.framework.third.weixin.util.HeadResourseUtil;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeixinBaseUserDetail
extends AbstractResponse
implements Serializable {
    private static final long serialVersionUID = 8921834510591181079L;
    private static final Logger logger = LogManager.getLogger(WeixinBaseUserDetail.class);
    @SerializedName(value="openid")
    private String openId;
    @SerializedName(value="nickname")
    private String nick;
    @SerializedName(value="sex")
    private Integer sex;
    @SerializedName(value="province")
    private String province;
    @SerializedName(value="city")
    private String city;
    @SerializedName(value="country")
    private String country;
    @SerializedName(value="headimgurl")
    private String headIco;
    @SerializedName(value="privilege")
    private String[] privileges;
    @SerializedName(value="unionid")
    private String unionId;

    public String getOpenId() {
        return this.openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public Integer getSex() {
        return this.sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getHeadIco() {
        return this.headIco;
    }

    public void setHeadIco(String headIco) {
        this.headIco = headIco;
    }

    public String[] getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(String[] privileges) {
        this.privileges = privileges;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public boolean haveDetail() {
        return this.nick != null;
    }

    public String assemSign() {
        String type = this.sex == null ? "\u7f51\u53cb" : (this.sex == 1 ? "\u5c0f\u54e5\u54e5" : (this.sex == 2 ? "\u5c0f\u59d0\u59d0" : "\u7f51\u53cb"));
        return String.format("\u6211\u662f\u6765\u81ea%s\uff0c%s\u7701\uff0c%s\u5e02\u7684%s", this.getCountry(), this.getProvince(), this.getCity(), type);
    }

    public Optional<String> findUsefulOriginHeadIcon() {
        return Optional.ofNullable(this.headIco).map(HeadResourseUtil::findWeixinPhotoResourse);
    }

    public Optional<String> loadUsefulOriginHeadIcon(Function<String, String> resourceChanger) {
        return this.findUsefulOriginHeadIcon().map(resource -> {
            try {
                return (String)resourceChanger.apply((String)resource);
            }
            catch (Throwable e) {
                logger.error(String.format("\u5c1d\u8bd5\u6362\u53d6\u8d44\u6e90\u65f6\u51fa\u9519,res:[%s]", resource), e);
                return null;
            }
        });
    }
}

