/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.v3.client;

import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateContainer;
import com.mini.framework.third.weixin.wxpay.v3.client.ClientConfigAttach;
import com.mini.framework.third.weixin.wxpay.v3.client.MarketDirectFeignHttpClient;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.AccountResultFileResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.Html5CreatePayOrderResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.JsApiCreatePayOrderResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.JsApiWebJsRequestBean;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayCreatePayOrderRequest;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayQueryPayOrderResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayRefundPayOrderRequest;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayRefundPayOrderResponse;
import com.mini.framework.util.asserts.AssertUtil;

public class MarketDirectFeignHttpClientDelegate
implements MarketDirectFeignHttpClient {
    private final MarketDirectFeignHttpClient realInstance;
    private final WxpayMarketCertificateContainer certificateContainer;

    @Override
    public void applyConfigIfRequire(ClientConfigAttach clientConfigAttach) {
        clientConfigAttach.applyClientConfig(this.certificateContainer);
    }

    @Override
    public String showCurrentHadMarketKey() {
        return this.certificateContainer.sureHaveMarketKeyForSignature();
    }

    public MarketDirectFeignHttpClientDelegate(MarketDirectFeignHttpClient realInstance, WxpayMarketCertificateContainer certificateContainer) {
        this.realInstance = realInstance;
        this.certificateContainer = certificateContainer;
    }

    @Override
    public WxpayQueryPayOrderResponse queryPayOrderBySiteOrder(String marketKey, String siteOrderNumber) {
        AssertUtil.assertMethodRequire((Object)marketKey, (String)"marketKey");
        AssertUtil.assertMethodRequire((Object)siteOrderNumber, (String)"siteOrderNumber");
        return this.realInstance.queryPayOrderBySiteOrder(marketKey, siteOrderNumber);
    }

    @Override
    public WxpayQueryPayOrderResponse queryPayOrderByWxpayOrder(String marketKey, String wxpayOrderNumber) {
        AssertUtil.assertMethodRequire((Object)marketKey, (String)"marketKey");
        AssertUtil.assertMethodRequire((Object)wxpayOrderNumber, (String)"wxpayOrderNumber");
        return this.realInstance.queryPayOrderByWxpayOrder(marketKey, wxpayOrderNumber);
    }

    @Override
    public WxpayQueryPayOrderResponse closePayOrderBySiteOrder(String marketKey, String siteOrderNumber) {
        AssertUtil.assertMethodRequire((Object)marketKey, (String)"marketKey");
        AssertUtil.assertMethodRequire((Object)siteOrderNumber, (String)"siteOrderNumber");
        return this.realInstance.closePayOrderBySiteOrder(marketKey, siteOrderNumber);
    }

    @Override
    public WxpayRefundPayOrderResponse executeRefundPayOrder(WxpayRefundPayOrderRequest request) {
        AssertUtil.assertMethodRequire((Object)request, (String)"request");
        return this.realInstance.executeRefundPayOrder(request);
    }

    @Override
    public WxpayRefundPayOrderResponse queryRefundPayOrderBySiteOrder(String siteRefundOrderNumber) {
        AssertUtil.assertMethodRequire((Object)siteRefundOrderNumber, (String)"siteRefundOrderNumber");
        return this.realInstance.queryRefundPayOrderBySiteOrder(siteRefundOrderNumber);
    }

    @Override
    public AccountResultFileResponse queryDailyHistoryOrdersFile(String day, String tradeType) {
        AssertUtil.assertMethodRequire((Object)day, (String)"day");
        AssertUtil.assertMethodRequire((Object)tradeType, (String)"tradeType");
        return this.realInstance.queryDailyHistoryOrdersFile(day, tradeType);
    }

    @Override
    public byte[] downloadByteArrayResultFileByTokenTypePath(String path, String token) {
        AssertUtil.assertMethodRequire((Object)path, (String)"path");
        AssertUtil.assertMethodRequire((Object)token, (String)"token");
        return this.realInstance.downloadByteArrayResultFileByTokenTypePath(path, token);
    }

    @Override
    public Html5CreatePayOrderResponse createHtml5PayOrder(WxpayCreatePayOrderRequest request) {
        AssertUtil.assertMethodRequire((Object)request, (String)"request");
        request.applyClientConfig(this.certificateContainer);
        return this.realInstance.createHtml5PayOrder(request);
    }

    @Override
    public JsApiCreatePayOrderResponse createJsApiPayOrder(WxpayCreatePayOrderRequest request) {
        AssertUtil.assertMethodRequire((Object)request, (String)"request");
        request.applyClientConfig(this.certificateContainer);
        JsApiCreatePayOrderResponse response = this.realInstance.createJsApiPayOrder(request);
        response.setRequest(request);
        JsApiWebJsRequestBean jsBean = JsApiWebJsRequestBean.fromPayOrderResponse(response);
        jsBean.signatureThenFillResult(this.certificateContainer.getCertificateContentString());
        response.setJsWebRequest(jsBean);
        return response;
    }
}

