package com.mini.framework.util.cache.annotation.springboot2;

import java.time.Duration;

import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;


public class CustomRedisCacheManager extends RedisCacheManager{

	
	private RedisConnectionFactory redisConnectionFactory ;
	
	private RedisCacheConfiguration baseCacheConfig;
	
	
	public CustomRedisCacheManager(CacheKeyPrefix cacheKeyPrefix,RedisConnectionFactory redisConnectionFactory,RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
		super(cacheWriter, defaultCacheConfiguration);
		this.baseCacheConfig = AbstractRedisCacheSupport.createBaseCacheConfiguration(cacheKeyPrefix );
		this.redisConnectionFactory = redisConnectionFactory;
	}
	
	/**
	 * 重写父类生成缓存器的方法，达到修改缓存时间的目的 
	 */
	public RedisCache createRedisCache(String name,  RedisCacheConfiguration cacheConfig) {
		String[] splits = name.split(CustomCacheKeyPrefix.expireSplit);
		AssertUtil.assertSupport(splits.length==2, "缓存key:[%s]有且只能包含1个#", name);
		try{
			Long expire = Long.parseLong(splits[1]);  
			RedisCacheWriter cacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter(redisConnectionFactory);
			RedisCacheConfiguration customCacheConfig = baseCacheConfig.entryTtl(Duration.ofSeconds(expire));
			return new CustomRedisCache(name, cacheWriter, customCacheConfig);
		}catch(NumberFormatException e){
			throw new BusyException(Status.Busy.fatalBug,"缓存key:[%s]中#后面文字:[%s]的必须是整数单位秒", name,splits[1]);
		}
	}
}