package com.mini.framework.util.code;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;

/**
 * 开发的代码描述
 * @author jayheo
 *
 */
public class DevCodeDescUtil {

	public static List<DevCodeDescJavaFile> javaFilesOfDir(String dir){
		File file = new File(dir);
		Collection<File> javaFiles = FileUtils.listFiles(file, new SuffixFileFilter("java") , DirectoryFileFilter.DIRECTORY );
		List<DevCodeDescJavaFile> javaDesces = javaFiles.stream().map(DevCodeDescJavaFile::fromUtf8File).collect(Collectors.toList());
		return javaDesces;
	}
	
}
