package com.mini.framework.util.code;

import org.apache.commons.lang3.ArrayUtils;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.core.status.Status;

/**
 * 唯一编码映射util
 * @author jayheo
 *
 */
public class UnionCodeUtil {
	/**
	 * 
	 */
	public final static String codeAll = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	/**
	 * 保留的字段
	 */
	public final static String codeRetain = "hR4s6T9q";
	public final static String codeScope = replaceRetain(codeAll);
	
	
	/**
	 * 计算可以使用字段范围
	 * @param sourseCode
	 * @param codeRetain
	 * @return
	 */
	private static String fillRetain(String sourseCode,int codeLength){
		AssertUtil.simpleAssertByStatus(sourseCode.length()<=codeLength, Status.Logic.def ,"源code:[%s]长度已大于要填充的长度%s", sourseCode,codeLength);
		
		
		while (sourseCode.length()<codeLength) {
			int disturb = createDisturb(sourseCode);
			sourseCode += codeRetain.charAt((disturb+disturb * sourseCode.length() * codeLength)%codeRetain.length());
		}
		return sourseCode;
	}
	
	
	private static int createDisturb(String param){
		long disturb = 1;
		for (int i = 0; i < param.length(); i++) {
			disturb *= param.charAt(i);
		}
		
		for (int i = 0; i < param.length(); i++) {
			disturb /=32;
		}
		return Math.abs((int)disturb);
	}
	
	
	
	
	private static String replaceRetain(String sourseCode){
		String targetCode = sourseCode;
		for (int i = 0; i < codeRetain.length(); i++) {
			targetCode = targetCode.replace(String.valueOf(codeRetain.charAt(i)), "");
		}
		return targetCode;
	}
	
	
	/**
	 * 被映射的元素个数
	 */
	private int mapSize;
	
	/**
	 * 映射码长度。
	 */
	private int codeLength;

	/**
	 * @param length 必须指定原码算法长度
	 */
	public UnionCodeUtil(int mapSize,int codeLength){
		this.mapSize = mapSize;
		this.codeLength = codeLength;
	}
	
	/**
	 * 解码<br>
	 * 把字符串解码成整形数组<br>
	 * @param codeList
	 * @return
	 */
	public int[] decode(String codeList){
		AssertUtil.simpleAssertByStatus(codeList!=null, Status.Logic.def, "union不能为空");
		codeList = replaceRetain(codeList);
		long lon = 0;
		
		for (int i = 0; i < codeList.length(); i++) {
			lon*=codeScope.length();
			char code = codeList.charAt(i);
			int val = codeScope.indexOf(code);
			AssertUtil.simpleAssertByStatus(val>=0,Status.Handle.enDeCode,"[%s]不是一个合法的unionCode",codeList);
			lon += val;
		}
		
		String str = String.valueOf(lon);
		int strLen = str.length();
		
		int[] sourses = new int[mapSize];
		
		int offset = 1;
		
		try{
			for (int i = 0; i < sourses.length; i++) {
				int len = str.charAt(strLen-mapSize+i)-48 + 1;
				sourses[i] = Integer.parseInt(str.substring(offset, offset + len));
				offset+=len;
			}
		}catch(StringIndexOutOfBoundsException e){
			throw new HandleEnDeCodeException(e,"[%s]不是一个合法的unionCode",codeList);
		}
		viledateFormat(sourses);
		ArrayUtils.reverse(sourses);
		return sourses;
	}
	
	private void viledateFormat(int... sourses){
		AssertUtil.simpleAssertByStatus(
				sourses.length==mapSize,Status.Handle.enDeCode,"参数长度必须为%s位",mapSize);
		
		for (int sourse : sourses) {
			AssertUtil.simpleAssertByStatus(
					sourse > 0,Status.Handle.enDeCode,"sourse[%s]必须大于0",sourse);
		}
	}
	
	/**
	 * 调用这个方法要注意总长度不能太长，不然会出错
	 * 编码<br>
	 * 把整形数组编码成字符串<br>
	 * @param sourse 编码因子<br>
	 * @return
	 */
	public String encode(int... sourses) {
		viledateFormat(sourses);
		//返回转顺序
		ArrayUtils.reverse(sourses);
		//结尾部分
		String suffix = "";
		//中间部分
		String midfix = "";
		//总和
		int sum = 0;
		for (int sourse : sourses) {
			suffix += length(sourse) - 1;
			midfix += sourse;
			sum += sourse;
		}

		String longChar = (sum%9+1) + midfix  + suffix;
		long lon = Long.parseLong(longChar);
		String code = "";
		 while (lon > 0){
			long yu = lon % codeScope.length();
			lon /= codeScope.length();
			code = codeScope.charAt((int) yu)  + code;
		 }
		code = fillRetain(code, codeLength);
		return code;
	}

	public static int length(int sourse) {
		return String.valueOf(sourse).toString().length();
	}
}
