package com.mini.framework.util.log.trace;

import com.mini.framework.util.asserts.AssertUtil;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * map持久器，实现这个接口要提供保存和查询map的方法
 * @author jayheo
 *
 */
public interface MapStorager {
	
	public void set(Map<String, String> map);
	
	public Map<String, String> get();

	/**
	 * 通过map来创建实例
	 * @param store
	 * @return MapStorager
	 */
	static MapStorager createFromMap(Map<String,String> store){
		AssertUtil.assertMethodRequire(store,"store");
		return new MapStorager() {
			@Override
			public void set(Map<String, String> map) {
				store.putAll(map);
			}

			@Override
			public Map<String, String> get() {
				return new HashMap<>(store);
			}
		};
	}

	/**
	 * 生成一个内存实例
	 * 直接拿一个map来实现的
	 * @return MapStorager
	 */
	static MapStorager createMemoryInstance(){
		return createFromMap(new ConcurrentHashMap<>());
	}
}
