package com.mini.framework.util.oss.bean;

import java.util.Optional;

import com.mini.framework.core.exception.standard.UnsupportedException;

/**
 * 地图的方法
 * @author jayheo
 *
 */
public enum MapDirection {
	nw(0,0), north(0,1), ne(0,2), west(1,0), center(1,1), east(1,2), sw(2,0), south(2,1), se(2,2);
	
	private int nsIndex;
	private int weIndex;
	
	
	public int getNsIndex() {
		return nsIndex;
	}

	public void setNsIndex(int nsIndex) {
		this.nsIndex = nsIndex;
	}

	public int getWeIndex() {
		return weIndex;
	}

	public void setWeIndex(int weIndex) {
		this.weIndex = weIndex;
	}

	private MapDirection(int nsIndex, int weIndex) {
		this.nsIndex = nsIndex;
		this.weIndex = weIndex;
	}
	
	/**
	 * 返回南北向的起始位置
	 * @param size
	 * @param offset
	 * @param limit
	 * @return
	 */
	public Optional<Integer> countNsFromPoint(int size,int offset,int limit){
		return countFromPoint(true, size, offset, limit);
	}
	/**
	 * 返回东西向的起始位置
	 * @param size
	 * @param offset
	 * @param limit
	 * @return
	 */
	public Optional<Integer> countWeFromPoint(int size,int offset,int limit){
		return countFromPoint(false, size, offset, limit);
	}
	
	private Optional<Integer> countFromPoint(boolean ns,int size,int offset,int limit){
		int judge = ns ?nsIndex:weIndex;
		switch (judge) {
		case 0:
			return Optional.of(offset);
		case 1:
			return Optional.empty();
		case 2:
			return Optional.of(size-(offset + limit));
		default:
			throw new UnsupportedException("countFromPoint中index出现了012以外数字:[%s]", judge);
		}
	}

}
