package com.mini.framework.util.oss.bean.work.modify;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.oss.bean.OssImageProcessParams;

/**
 * 图片切圆角
 * https://help.aliyun.com/document_detail/44694.html?spm=a2c4g.11186623.6.1242.2c4d2e93jzmuFR
 * 
 * @author jayheo
 *
 */
@Desc("图片切圆角 https://help.aliyun.com/document_detail/44694.html?spm=a2c4g.11186623.6.1242.2c4d2e93jzmuFR")
public class RoundedCornersModifyOssImageWork extends ModifyOssImageWork {

	@Desc("将图片切出圆角，指定圆角的半径。[1, 4096] ")
	private Integer radius;

	public Integer getRadius() {
		return radius;
	}

	public void setRadius(Integer radius) {
		this.radius = radius;
	}

	@Override
	public OssImageProcessParams mapperProcessParams(Function<String, String> sureSameBucket) {
		return OssImageProcessParams.roundedCornersProcess(radius);
	}

	public static  List<RoundedCornersModifyOssImageWork> createExamples() {
		RoundedCornersModifyOssImageWork example = new RoundedCornersModifyOssImageWork();
		example.setWorkDesc("图片切圆角");
		List<RoundedCornersModifyOssImageWork> examples = new ArrayList<>();
		examples.add(example);
		return examples ;
	}

}
