package com.mini.framework.util.page;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 分页
 * TODO 待继续优化。要和section打通
 * @author jayheo
 */
public class Page {

    /**
     * 第几页。
     * 0代表第一页
     * */
    private Integer pageIndex;


    /**
     * 每一页的数量。
     * */
    private Integer pageSize;

    /**
     * 分页查询的时候指定已知count，对于翻页操作的时候完全不需要多次查总数。
     */
    private Integer count;



    /**
     * 转成section
     * */
    public Section createSection(){
        AssertUtil.assertNotFatalBug(ifComplete(),"page内容不完整不能转成section");
        return new Section(pageIndex*pageSize,pageSize,count);
    }

    /**
     * 是不是完整的
     * */
    public boolean ifComplete(){
        return (pageIndex!=null && pageSize>=0) && (pageSize!=null && pageSize>0);
    }

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }
}
