package com.mini.framework.util.params;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map.Entry;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.CharsetUtf8Util;
import com.mini.framework.util.string.UnSplitUtil;

public class UrlParams {


	public static String appendParamsToUrl(String url,String paramString) {
		AssertUtil.haveParams(url, "url不能为空");

		AssertUtil.haveParams(paramString, "paramString不能为空");
		if(paramString.length()>0){
			url += url.indexOf('?')<0?"?":"&";
			url += paramString;
		}
		return url;
	}
	

	public static String toParamString(LinkedHashMap<String, String> params,String url) {
		return appendParamsToUrl(url,toParamString(params));
	}
	
	public static String toParamString(LinkedHashMap<String, String> params) {
		params = new LinkedHashMap<>(params);
		for (Entry<String, String> entry : params.entrySet()) {
			if(entry.getValue()!=null){
				entry.setValue(CharsetUtf8Util.urlEncode(String.valueOf( entry.getValue())));
			}
		}
		
		return UnSplitUtil.toParamString(params);
	}
}
