package com.mini.framework.util.report.statistics.protocol;


import java.util.Date;

/**
 * 统计结果的属性
 */
public class StatisticsResultMeta {


    /**
     * 统计的截至时间。<BR>
     * 为了降低 统计的复杂度，实际统计的截止时间可能会小于一开始传入的时间，这里记录实时的统计截止时间<BR>
     * 例如，当前时间是  2022年10月3日20点 15分，要统计22年的用户地域分布，<BR>
     * 那么 舍弃那15分钟，节省 36个省的36次统计是划得来的。<BR>
     */
    private Date limitDate;

    public StatisticsResultMeta() {
    }

    public StatisticsResultMeta(Date limitDate) {
        this.limitDate = limitDate;
    }

    public Date getLimitDate() {
        return limitDate;
    }

    public void setLimitDate(Date limitDate) {
        this.limitDate = limitDate;
    }
}
