package com.mini.framework.util.report.statistics.protocol.process;


import com.mini.framework.util.asserts.AssertUtil;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.Date;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Supplier;

/**
 * 分解查询的点。
 */
public class ForkQuerySpot<R> {

    //TODO 是不是在等待中。


    private Date readyDate;

    /**
     * 开始时间
     */
    private Date beginDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 用过的时间长度
     */
    private Long executeTime;


    /**
     * 等待的时间
     */
    private Long waitTime;



    /**
     * 总共使用过的时间
     */
    private Long fullyTime;


    private Object processParams;
    
    private Future<R> asyncExecutor;

    /**
     * 同步的结果
     */
    private R syncResult;
    
    private void countTimeConsume(){
        AssertUtil.assertMethodRequire(beginDate,"beginDate");
        AssertUtil.assertMethodRequire(endDate,"endDate");
        executeTime = endDate.getTime() - beginDate.getTime();
        waitTime = beginDate.getTime() - readyDate.getTime();
        fullyTime = executeTime + waitTime;
    }


    /**
     * 创建并开始
     * @param task
     * @param executor
     * @param <R>
     * @return
     */
    public static <R> ForkQuerySpot<R> createThenAsyncBegin(Supplier<R> task, Executor executor,Object processParams){
        AssertUtil.assertMethodRequire(executor,"executor");
        AssertUtil.assertMethodRequire(task,"task");
        ForkQuerySpot<R> instance = new ForkQuerySpot<>();
        instance.readyDate = new Date();
        instance.asyncExecutor = CompletableFuture.supplyAsync(()->{
            instance.processParams = processParams;
            instance.beginDate = new Date();
            R result = task.get();
            instance.endDate = new Date();
            instance.countTimeConsume();
            return result;
        },executor);
        return instance;
    }


    /**
     * 创建然后开始执行
     * @param task
     * @return
     */
    public R fillThenSyncBegin(Supplier<R> task){
        AssertUtil.assertMethodRequire(task,"task");
        if (syncResult == null) {
            beginDate = new Date();
            readyDate = new Date(beginDate.getTime());
            syncResult = task.get();
            asyncExecutor = CompletableFuture.completedFuture(syncResult);
            endDate = new Date();
            countTimeConsume();
        }
        return syncResult;
    }

    public Date getReadyDate() {
        return readyDate;
    }

    public void setReadyDate(Date readyDate) {
        this.readyDate = readyDate;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getExecuteTime() {
        return executeTime;
    }

    public void setExecuteTime(Long executeTime) {
        this.executeTime = executeTime;
    }

    public Long getWaitTime() {
        return waitTime;
    }

    public void setWaitTime(Long waitTime) {
        this.waitTime = waitTime;
    }

    public Long getFullyTime() {
        return fullyTime;
    }

    public void setFullyTime(Long fullyTime) {
        this.fullyTime = fullyTime;
    }

    public Object getProcessParams() {
        return processParams;
    }

    public void setProcessParams(Object processParams) {
        this.processParams = processParams;
    }

    public Future<R> showAsyncExecutor(){
        return asyncExecutor;
    }
    
    public Optional<R> showSyncResult(){
        return Optional.ofNullable(syncResult);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
