package com.mini.framework.util.schedule;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 分不同的商家高度一些任务
 * @author jayheo
 *
 */
@Target({ElementType.METHOD, ElementType.ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SiteScheduled {

	/**
	 * 延迟执行单位秒钟
	 * 对应一个定时执行的东西建议选用质数来做
	 * @return
	 */
	int fixedDelay();

	/**
	 * 延迟执行后以后的执行间隔单位秒钟
	 * 对应一个定时执行的东西建议选用质数来做
	 * @return
	 */
	int fixedRate();
	
	
	/**
	 * 每个任务都必须有一个唯一的id
	 * @return
	 */
	String taskId();


	/**
	 * 最大干扰因子，单位是秒钟
	 * 默认不干扰。
	 * */
	int fixedDisturb() default 0;

}
