package com.mini.framework.util.string;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.mini.framework.util.params.MapParams;
import org.apache.commons.lang3.StringUtils;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * @author jayheo
 */
public class UnSplitUtil {

	public static String toLikeParamString(LinkedHashMap<String, String> kvs,String itemSplit,String pairSplit) {
		AssertUtil.haveParams(kvs, "toParamString参数不能为空");
		List<String> paramItems = kvs.entrySet().stream()
				.filter(entry->entry.getValue()!=null)
				.map(entry->entry.getKey() + pairSplit+ entry.getValue())
				.collect(Collectors.toList());
		return StringUtils.join(paramItems,itemSplit);
	}
	
	public static String toParamString(LinkedHashMap<String, String> kvs) {
		return toLikeParamString(kvs, "&","=");
	}



	/**
	 * 从url类型的转过来
	 * @return
	 */
	public static LinkedHashMap<String, String> fromUrlParams(String urlParams){
		AssertUtil.assertMethodRequire(urlParams,"urlParams");
		LinkedHashMap<String, String> map = new LinkedHashMap<>();
		if(urlParams.length()==0){
			return map;
		}else{
			Stream.of(urlParams.split("&"))
					.filter(StringUtils::isNotEmpty)
					.forEach(param->{
						String[] items = param.split("=");
						String name = items[0];
						String value = Stream.of(items).skip(1).findFirst()
								.filter(StringUtils::isNotEmpty)
								.map(StringUtil::urlDecode)
								.orElse(null);
						map.put(name,value);
			});	
			return map;
		}
	}
}
