package com.mini.framework.util.string;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import com.mini.framework.util.bean.BeanUtil;
import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;

public class XStreamUtil {
	/**
	 * 把对象转成xml
	 * @param bean
	 * @return
	 */
	public static String toXml(Object bean) {
		XStream xstream = simpleXStream();
		xstream.processAnnotations(bean.getClass());
		String xml = xstream.toXML(bean);
		return xml;
	}
	
	public static XStream simpleXStream(){
		//https://www.cnblogs.com/zolo/p/5849299.html
		XStream xstream = new XStream(new Xpp3Driver(new NoNameCoder()));
		XStream.setupDefaultSecurity(xstream);
		//xstream.processAnnotations(bean.getClass());
		xstream.autodetectAnnotations(true);
		xstream.ignoreUnknownElements();
		return xstream; 
	}
	
	/**
	 *  有些bean加了xstream的注解，如果转成map要保留xstream上的字段注解名是可以使用这个方法
	 * @param bean
	 * @return
	 */
	public static Map<String, String> beanToMap(Object bean){
    	Map<String, String> map = new HashMap<String, String>();
        for (Field field : BeanUtil.getAllField(bean)) {
            field.setAccessible(true);
            String fieldName = field.getName();
            //如果 element 注解 name 字段设置了内容, 使用其当成字段名
            XStreamAlias xStreamAlias = field.getAnnotation(XStreamAlias.class);
            if (xStreamAlias != null) {
                fieldName = xStreamAlias.value();
            }
            Object val;
			try {
				val = field.get(bean);
				String value = val == null ?null: String.valueOf(val);
				map.put(fieldName, value);
			} catch (IllegalArgumentException | IllegalAccessException e) {
				throw new HandleEnDeCodeException(e,"%s在生成map时出错",bean);
			}
        }
        return map;
	}
	
	public static <B> B fromXml(String xml,Class<B> clazz) {
		XStream xstream = simpleXStream();
		xstream.allowTypes(new Class[]{clazz});
		xstream.processAnnotations(clazz);
		B bean = (B) xstream.fromXML(xml);
		return bean;
	}
}
