package com.mini.framework.util.surplus.reduce;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateUtil;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.IntStream;

/**
 * 剩余量单项实体
 * @author jayheo
 */
public class ReduceQueueItem {

    /**
     * 时间和随机数
     * */
    private String timeRandom;

    private Date itemRecordDate;

    /**
     * 空状态的过期时间
     * */
    private Date lackExpireDate;


    public static ReduceQueueItem createLackItem(Date itemRecordDate, Date expireDate, long increment){
        ReduceQueueItem item = createEffectiveItem(itemRecordDate);
        AssertUtil.assertMethodRequire(expireDate,"expireDate");
        item.setLackExpireDate(new Date(expireDate.getTime() + increment));
        return item;
    }

    public static ReduceQueueItem createEffectiveItem(Date itemRecordDate){
        AssertUtil.assertMethodRequire(itemRecordDate,"itemRecordDate");
        ReduceQueueItem item = new ReduceQueueItem();
        String timeRandom = DateUtil.toMilSecondsNumeric(itemRecordDate) + StringUtils.leftPad("0",6,String.valueOf(System.nanoTime()/100000));
        item.setTimeRandom(timeRandom);
        item.setItemRecordDate(itemRecordDate);
        return item;
    }

    public static List<ReduceQueueItem> createEffectiveItemArray(Date itemRecordDate, int size){
        List<ReduceQueueItem> itemArray = new ArrayList<>();
        IntStream.range(0,size).forEach(index->itemArray.add(createEffectiveItem(itemRecordDate)));
        return itemArray;
    }


    public static List<ReduceQueueItem> createEffectiveAndLackItemArray(Date itemRecordDate, int effectiveSize,int lackSize, Date expireDate, long increment){
        List<ReduceQueueItem> effectiveItemArray = createEffectiveItemArray(itemRecordDate,effectiveSize);
        List<ReduceQueueItem> lackItemArray = ReduceQueueItem.createLackItemArray(itemRecordDate, lackSize, new Date(),increment);
        List<ReduceQueueItem> allItemArray = new ArrayList<>();
        allItemArray.addAll(effectiveItemArray);
        allItemArray.addAll(lackItemArray);
        return allItemArray;
    }
    

    public static List<ReduceQueueItem> createLackItemArray(Date itemRecordDate, int size, Date expireDate, long increment){
        List<ReduceQueueItem> itemArray = new ArrayList<>();
        IntStream.range(0,size).forEach(index->itemArray.add(createLackItem(itemRecordDate,expireDate,increment)));
        return itemArray;
    }

    public boolean ifNotLack(){
        return !ifLack();
    }
    public boolean ifLack(){
        return lackExpireDate!=null;
    }
    public boolean ifCompleteRecord(){
        return itemRecordDate!=null;
    }

    /**
     * 在当前看来是不是空状态且是不是过期了
     * */
    public boolean ifLackAndExpire(){
        return ifLackAndExpire(new Date());
    }

    /**
     * 在当前看来是不是空状态且是不是有效的
     * */
    public boolean ifLackAndEffective(){
        return ifLackAndEffective(new Date());
    }

    /**
     * 是不是空状态且是不是有效的
     * */
    public boolean ifLackAndEffective(Date now){
        return ifLack() && lackExpireDate.after(now);
    }

    /**
     * 是不是空状态且是不是有效的
     * */
    public boolean ifLackAndExpire(Date now){
        return ifLack() && lackExpireDate.after(now);
    }

    public Date getLackExpireDate() {
        return lackExpireDate;
    }

    public void setLackExpireDate(Date lackExpireDate) {
        this.lackExpireDate = lackExpireDate;
    }

    public Date getItemRecordDate() {
        return itemRecordDate;
    }

    public void setItemRecordDate(Date itemRecordDate) {
        this.itemRecordDate = itemRecordDate;
    }

    public String getTimeRandom() {
        return timeRandom;
    }

    public void setTimeRandom(String timeRandom) {
        this.timeRandom = timeRandom;
    }

    @Override
    public String toString() {
        return String.format("ifNotLack:[%s],ifLackAndExpire:[%s],ifLackAndEffective:[%s],%s"
                ,ifNotLack(),ifLackAndExpire(),ifLackAndEffective()
                , ToStringBuilder.reflectionToString(this));
    }
}
