package com.mini.framework.util.thread;


import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mini.framework.util.log.trace.LinkTraceFace;
import com.mini.framework.util.log.trace.MethodTracePointer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 如果 对参数不理解？看看这几个文章</br>
 https://developer.aliyun.com/article/756612?scm=20140722.184.2.173</br>
 https://zhuanlan.zhihu.com/p/32867181?spm=a2c6h.12873639.0.0.ccbf7105xdsF7U</br>
 https://mp.weixin.qq.com/s/-89-CcDnSLBYy3THmcLEdQ?spm=a2c6h.12873639.0.0.ccbf7105xdsF7U</br>

 * 异步执行线程管理
 * @author jayheo
 */
public abstract class AbstractAsyncThreadExecutor {

    private static Logger logger = LogManager.getLogger(AbstractAsyncThreadExecutor.class);

    private String threadNameFormat = "async-thread-execute-%s";

    private int corePoolSize;
    private int waitingQueueSize;
    private int maximumPoolSize;
    private long keepAliveMilliSeconds;

    private ThreadFactory threadFactory;
    private ExecutorService threadPool;


    public AbstractAsyncThreadExecutor(int corePoolSize, int waitingQueueSize, int maximumPoolSize, long keepAliveMilliSeconds) {
        this.corePoolSize = corePoolSize;
        this.waitingQueueSize = waitingQueueSize;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveMilliSeconds = keepAliveMilliSeconds;
        this.afterInit();
    }

    public AbstractAsyncThreadExecutor(String threadNameFormat, int corePoolSize, int waitingQueueSize, int maximumPoolSize, long keepAliveMilliSeconds) {
        this.threadNameFormat = threadNameFormat;
        this.corePoolSize = corePoolSize;
        this.waitingQueueSize = waitingQueueSize;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveMilliSeconds = keepAliveMilliSeconds;
        this.afterInit();
    }

    public AbstractAsyncThreadExecutor afterInit(){
        this.threadFactory = new ThreadFactoryBuilder().setNameFormat(this.threadNameFormat).build();
        this.threadPool = new ThreadPoolExecutor(corePoolSize,maximumPoolSize,this.keepAliveMilliSeconds, TimeUnit.MILLISECONDS,new LinkedBlockingQueue(this.waitingQueueSize)
                ,this.threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        return this;
    }


    public void execute(final Runnable origin){
        threadPool.execute(aroundRunnable(origin));
    }


    protected Runnable aroundRunnable(final Runnable origin){
        final String siteId = getLocalThreadSiteId().get();
        return ()->{
            ObjectThreadCachable<String> localThreadSiteId = getLocalThreadSiteId();
            localThreadSiteId.begin();
            localThreadSiteId.set(siteId);
            LinkTraceFace.markSiteId(siteId);
            //TODO 担心这里可能有错拿不一线程
            getMethodTracePointer().autoPoint();
            try{
                origin.run();
            }finally {
                localThreadSiteId.clear();
                getMethodTracePointer().endTrace();
            }
        };
    }





    /**
     * 获取当前线程的商家id
     * @return ObjectThreadCachable<String>
     * */
    public abstract ObjectThreadCachable<String> getLocalThreadSiteId();


    /**
     * 获取当前的方法点
     * @return MethodTracePointer
     * */
    public abstract MethodTracePointer getMethodTracePointer();


    public String getThreadNameFormat() {
        return threadNameFormat;
    }

    public void setThreadNameFormat(String threadNameFormat) {
        this.threadNameFormat = threadNameFormat;
    }

    public int getCorePoolSize() {
        return corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getWaitingQueueSize() {
        return waitingQueueSize;
    }

    public void setWaitingQueueSize(int waitingQueueSize) {
        this.waitingQueueSize = waitingQueueSize;
    }

    public int getMaximumPoolSize() {
        return maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public long getKeepAliveMilliSeconds() {
        return keepAliveMilliSeconds;
    }

    public void setKeepAliveMilliSeconds(long keepAliveMilliSeconds) {
        this.keepAliveMilliSeconds = keepAliveMilliSeconds;
    }
}
