package com.mini.framework.util.alert.exception;

import com.mini.framework.util.aspect.AspectBeanUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Pointcut;

/**
 * @author jayheo
 * 
 * 对应RabbitListener出现异常后没有在error中记录信息所以加这个aop
 */
public abstract class RabbitListenerExceptionHandleSupport {

	private final static Logger logger = LogManager.getLogger(RabbitListenerExceptionHandleSupport.class);
	
    @Pointcut("@annotation(org.springframework.amqp.rabbit.annotation.RabbitListener)") 
    public void pointcut(){}
    
    @AfterThrowing(pointcut="pointcut()",throwing="exception")
    public void exceptionMark(JoinPoint joinPoint ,Throwable exception){
		String info = AspectBeanUtil.typeMethodArgsInfo(joinPoint);
		logger.error("found exception:{} on execute {}",exception.getMessage(),info,exception);
		try {
			mark(exception);
		} catch (Throwable e) {
			logger.debug("忽略记录日志再产生的异常",e);
			//ignore
		}
    }


    /**
	 * 对异常做一个标记
	 * */
    protected abstract void mark(Throwable exception) throws Throwable;
}
