package com.mini.framework.util.function;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 懒初始化bean</br>
 * 一般来说明变量应该是:先定义，再赋值，后应用</br>
 * 但是在函数式计算中会有 先定义，再应用(没有实际应用，只是写到回调函数中)，后赋值 的使用场景</br>
 * 这个需求与回调函数的 final 修饰冲突了，所以使用这个懒赋值初始话的方案
 * @author jayheo
 */
public class LazyAssignBean<B> {

    private B bean;

    private LazyAssignBean(){

    }

    public static <T> LazyAssignBean<T> create(){
        return new LazyAssignBean();
    }

    public LazyAssignBean initBean(B bean){
        AssertUtil.assertNotFatalBug(this.bean==null,"bean不能被多次赋值");
        AssertUtil.assertNotFatalBug(bean!=null,"bean不能为空");
        this.bean = bean;
        return this;
    }

    public B showBean(){
        AssertUtil.assertNotFatalBug(bean!=null,"bean不能为空");
        return bean;
    }

}
