package com.mini.framework.util.http.linked;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

import com.mini.framework.core.exception.HandleIOException;

public class HttpClientHelper {

	private static Logger logger = Logger.getLogger(HttpClientHelper.class.getName());
	

	public static HttpResponse execute(HttpRequest request) {
		CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
		HttpContext context = new BasicHttpContext();
		request.getBody().forEach((key, value) -> context.setAttribute(key, value));
		HttpRequestBase hrb = request.requestEntity();
		request.getHeader().forEach((key, value) -> hrb.addHeader(key, value));
		try {
			CloseableHttpResponse resp = closeableHttpClient.execute(hrb, context);
			Header[] headers = resp.getAllHeaders();
			//request.headerParser.accept(headerMap);
			int status = resp.getStatusLine().getStatusCode();
			InputStream content = resp.getEntity().getContent();
			byte[] byteBuf = IOUtils.toByteArray(content);
			return new  HttpResponse(request,status, new HttpHeaders(headers), byteBuf);
		} catch (IOException e) {
			//TODO 读文件的时候的错
			throw new HandleIOException(e,"发起http请求时出现io错误");
		}
	}
	

	
}
