package com.mini.framework.util.lambda.collect;

import java.util.List;
import java.util.function.BinaryOperator;

/**
 * 把二维集合合并
 * 
 * @author jayheo
 *
 */
public interface Merge {

	/**
	 * 简单的集合到一起
	 * @return
	 */
	public static <T> BinaryOperator< List<T>> simple() {

		BinaryOperator<List<T>> accumulator = (a, b) -> {
			a.addAll(b);
			return a;
		};
		return accumulator;
	}
	
}
