package com.mini.framework.util.log;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;
import java.util.stream.Stream;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.core.exception.BusyException;

/**
 * 以4w的形式记录事件和todo清单
 * 
 * @author jayheo
 *
 */
public class Event5WBuilder {
	
	/**
	 * 需要忽略的东西。
	 * 去掉与语句冲突的 .:和 |
	 */
	private static final String[] skips  = new String[]{"#:","\\|"};
	private static final String eventVersion = "v31";
	private static final String todoVersion = "v31";
	
	/**
	 * 陈述事件
	 */
	private static final String eventPattern = String.format("需要关注事件%s#:{6}-event({5}),时间#:{0},地点#:{1},谁#:{2},事情#:{3},方式#:{7},原因#:{4},结果#:{8},time#:{9},print#{10}",eventVersion);

	/**
	 * 待办事件
	 * 待处理工作 开发应该在明天地址svn做修改
	 */
	private static final String todoPattern = String.format("待处理工作%s#:{6}-todo({5}),需要#:{2},在#:{0},去#:{1},执行#:{3},方式#:{7},原因#:{4},结果#:{8},time#:{9},print#{10}",todoVersion);
	
	private String patternTemplate;
	
	private static final AsyncString emptyAsyncString = new AsyncString("无");

	private Object type;

	private int level;
	
	/**
	 * 创建这个的日期
	 */
	private long createDate;
	
	private int printTime;

	//TODO 添加一个条件控制要不要显示
	
	private AsyncString when = emptyAsyncString;
	
	private AsyncString who = emptyAsyncString;
	
	private AsyncString what = emptyAsyncString;
	
	private AsyncString where = emptyAsyncString;

	private AsyncString why = emptyAsyncString;
	
	private AsyncString how = emptyAsyncString;

	private AsyncString result = emptyAsyncString;
	
	private Event5WBuilder returnThis(){
		return this;
	}
	
	/**
	 * 级别越高越重要
	 * @param level
	 * @return
	 */
	public Event5WBuilder level(int level){
		AssertUtil.assertSupport(level>0&&level<=5, "级别必须为1,2,3,4,5中的一个");
		this.level = level;
		return returnThis();
	}

	/**
	 * 最重的标记
	 * @return
	 */
	public Event5WBuilder important(){
		return level(5);
	}

	/**
	 * 记录一个待办事件
	 * @param level
	 * @return
	 */
	public static Event5WBuilder todo(int level){
		return todo(level, "");
	}
	
	/**
	 * 记录一个待办事件
	 * @param level
	 * @param type
	 * @return
	 */
	public static Event5WBuilder todo(int level,Object type){
		Event5WBuilder temp = build(type).level(level);
		temp.patternTemplate = todoPattern;;
		return temp;
	}
	

	/**
	 * 记录一个事件。
	 * 比如说发生了什么事。
	 * 或者一个重要重点的记录
	 * @param level
	 * @return
	 */
	public static Event5WBuilder event(int level){
		return event(level, "");
	}
	
	
	/**
	 * 记录一个事件。
	 * 比如说发生了什么事。
	 * 或者一个重要重点的记录
	 * @param level
	 * @param type
	 * @return
	 */
	public static Event5WBuilder event(int level,Object type){
		Event5WBuilder temp = build(type).level(level);
		temp.patternTemplate = eventPattern;
		return temp;
	}

	private static Event5WBuilder build(Object type){
		AssertUtil.assertSupport(type!=null, "类型不能为空");
		Event5WBuilder temp = new Event5WBuilder();
		temp.createDate = System.currentTimeMillis();
		temp.printTime = 0;
		temp.type = type;
		return temp;
	}
	
	public Event5WBuilder what(String string,Object... params){
		this.what = createAsync(string, params);
		return returnThis();
	}


	public Event5WBuilder where(String string,Object... params){
		this.where = createAsync(string, params);
		return returnThis();
	}
	
	public Event5WBuilder when(String string,Object... params){
		this.when = createAsync(string, params);
		return returnThis();
	}

	public Event5WBuilder who(String string,Object... params){
		this.who = createAsync(string, params);
		return returnThis();
	}
	
	public Event5WBuilder why(String string,Object... params){
		this.why = createAsync(string, params);
		return returnThis();
	}
	
	/**
	 * 如何做
	 * @param string
	 * @param params
	 * @return
	 */
	public Event5WBuilder how(String string,Object... params){
		this.how = createAsync(string, params);
		return returnThis();
	}
	
	public Event5WBuilder result(String string,Object... params){
		this.result = createAsync(string, params);
		return returnThis();
	}
	
	public String levelMsg(){
		return String.valueOf(level);
	}
	
	public String typeMsg(){
		return String.valueOf(type);
	}
	
	public Event5WBuilder oneLine(){
		//TODO 实现只打在一行的功能
		return this;
	}
	
	public String create(){
		return create(false);
	}
	
	public String create(boolean oneLine){
		String time = (System.currentTimeMillis() - createDate) + "ms";
		String msg = MessageFormat.format(patternTemplate,
				when.call(),where.call(),who.call(),what.call(),why.call(),levelMsg(),typeMsg(),how.call(),result.call(),time,++printTime);
		return msg;
	}
	
	@Override
	public String toString() {
		return create();
	}
	
	private AsyncString createAsync(String string, Object[] params) {
		return new AsyncString(string, params);
	}
	
	static class AsyncString {
		
		private String string;
		
		private Object[] params;

		public String getString() {
			return string;
		}

		public void setString(String string) {
			this.string = string;
		}

		public Object[] getParams() {
			return params;
		}

		public void setParams(Object[] params) {
			this.params = params;
		}
		
		public AsyncString(String string, Object... params) {
			super();
			AssertUtil.assertSupport(string!=null, "内容不允许为空");
			for (String skip : skips) {
				//如果碰到[\|]就是不要出现|的意思
				AssertUtil.assertSupport(string.length() == string.replaceAll(skip, "").length(),"提示:[%s]语中不允许出现:[%s]",	string,skip);
			}
			try{
				String.format(string, new String[params.length]);
			}catch(Throwable e){
				throw new ServerException(e, String.format("出现严重问题需要检查format:[%s],和参数表个数:[%s]是否匹配",string,params.length));
			}
			this.string = string;
			this.params = params;
		}

		public String call() {
			try{
				String value = String.format(string, params);
				for (String skip : skips) {
					value = value.replaceAll(skip, "");
				}
				return value;
			}catch(MissingFormatArgumentException e){
				//TODO 这里要放到工具类中修改format方法。一般是%s对不上才会出来的bug
				throw new BusyException(e,"字符串格式化异常 string:%s,params:%s",string,Arrays.toString(params));
			}
		}
		
	}
	
	
}
