package com.mini.framework.util.log.trace;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * 链接跟踪器初始化<br>
 * 用于servlet中的web.xml中<br>
 *
 */
public class LinkTraceInit implements ServletContextListener{

	private static Logger logger = LogManager.getLogger(LinkTraceInit.class);


	/**
	 * TODO 这里显然是有问题，需要快速优化一下
	 * https://mvnrepository.com/artifact/commons-configuration/commons-configuration
	 * TODO 目前maven仓库已作了升级说明。
	 * TODO 之前一直找不到启动配置，也许可以在这里找一下灵感。
	 * Note: This artifact was moved to:
	 * org.apache.commons » commons-configuration2
	 */
	@Override
	public void contextInitialized(ServletContextEvent sce) {
		String colonyIndex = "99";
		String serverId = "99";
		ConfigurationException configException = null;
		String configpath = "c3fx.properties";
		String serverIdKey = "log.link.trace.server.id";
		String colonyIndexKey = "log.link.trace.colony.index";
		try {
			Configuration config = new PropertiesConfiguration(configpath);
			serverId = config.getString(serverIdKey)== null ? serverId:config.getString(serverIdKey);
			colonyIndex = config.getString(colonyIndexKey)== null ? colonyIndex:config.getString(colonyIndexKey);
		} catch (ConfigurationException e) {
			configException = e;
		}
		LinkTraceFace.setColonyIndex(colonyIndex);
		LinkTraceFace.setServerId(serverId);
		LinkTraceFace.pointSystemBoot();
		if(configException!=null){
			String warn = String .format("在配置文件:%s中查询%s和%s值时出错,现在已忽略，将使用默认值",configpath,serverIdKey,colonyIndexKey);
			logger.warn(warn,configException);
			//忽略
		}
	}

	@Override
	public void contextDestroyed(ServletContextEvent sce) {
	}
}
