package com.mini.framework.util.oss.bean.work;

import java.util.Optional;
import java.util.function.Function;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.bean.desc.Descable;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.work.type.WorkActionType;

/**
 * oss图片处理工作点
 * 
 * @author jayheo
 *
 */
public abstract class OssImageWork implements Descable {

	@Desc("oss用的图片操作的")
	private String ossAction;

	@Desc("图片操作类型")
	private WorkActionType workType;

	/**
	 * 排序
	 */
	@Desc("work的执行顺序优先执行小的")
	private Double sorter;
	
	@Desc("正对当前work做一些说明")
	private String workDesc;


	public WorkActionType getWorkType() {
		return workType;
	}

	public void setWorkType(WorkActionType workType) {
		this.workType = workType;
	}

	public String getOssAction() {
		return ossAction;
	}

	public void setOssAction(String ossAction) {
		this.ossAction = ossAction;
	}

	public double showSorter() {
		return Optional.ofNullable(sorter).orElse(1.0);
	}

	public Double getSorter() {
		return sorter;
	}

	public void setSorter(Double sorter) {
		this.sorter = sorter;
	}
	
	public String getWorkDesc() {
		return workDesc;
	}

	public void setWorkDesc(String workDesc) {
		this.workDesc = workDesc;
	}

	public OssImageWork fillParams(Double sorter,String workDesc) {
		this.sorter = sorter;
		this.workDesc = workDesc;
		return this;
	}

	public OssImageWork() {
		this.workType = WorkActionType.typeOf(this.getClass()).orElseThrow(
				() -> new ServerException(Status.Server.fatalBug, "类%s没有对应的WorkActionType", this.getClass()));
		this.ossAction = workType.ossAction();
	}

	public abstract OssImageProcessParams mapperProcessParams(Function<String, String> sureSameBucket);
}
