package com.mini.framework.util.oss.bean.work.type;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.oss.bean.work.OssImageWork;
import com.mini.framework.util.oss.bean.work.mark.ImageMarkOssImageWork;
import com.mini.framework.util.oss.bean.work.mark.TextMarkOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.CircleByRadiusOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.CircleByRoundedCornersOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.LimitResizeModifyOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.OffsetCropModifyOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.RoundedCornersModifyOssImageWork;
import com.mini.framework.util.type.EnumTypeShower;

/**
 * oss操作类型
 * @author jayheo
 *
 */
@Desc("oss操作类型的枚举")
public enum WorkActionType implements EnumTypeShower<WorkActionType>  {
	
	/**
	 * 图片水印
	 */
	@Desc("给图片加上图片水印")
	imageMark("watermark",ImageMarkOssImageWork.class), 
	/**
	 * 文本水印
	 */
	@Desc("给图片加上文本水印")
	textMark("watermark",TextMarkOssImageWork.class), 
	
	
	@Desc("把图片切成圆，不可以用于做水印")
	circleByRadius(null,CircleByRadiusOssImageWork.class),
	
	
	@Desc("把图片切成圆，可以用于做水印")
	circleByRoundedCorners(null,CircleByRoundedCornersOssImageWork.class),
	
	@Desc("将图片切出圆角，指定圆角的半径[1, 4096]，可以用于做水印")
	roundedCorners(null,RoundedCornersModifyOssImageWork.class),
	
	@Desc("根据位置裁剪")
	offsetCrop("crop",OffsetCropModifyOssImageWork.class),
	
	@Desc("根据限制缩放")
	limitResize("resize",LimitResizeModifyOssImageWork.class),	
	
	;

	public static final String typeKey = "workType";
	
	private Class<? extends OssImageWork> work;
	
	private String ossAction;
	
	public String ossAction(){
		return ossAction;
	}

	public Class<? extends OssImageWork> work() {
		return work;
	}

	private WorkActionType(String ossAction,Class<? extends OssImageWork> work) {
		this.ossAction = ossAction;
		this.work = work;
	}

	public static WorkActionType parse(String typeStr) {
		AssertUtil.assertMethodRequire(typeStr,"typeStr");
		//TODO 如果 typeStr 不存在任务一值的时候会报错，这个错误还没有合适的处理
		return WorkActionType.valueOf(typeStr);
	}
	
	public boolean matchWorkClass(Class<? extends OssImageWork> clazz){
		return work.equals(clazz);
	}

	public static Optional<WorkActionType> typeOf(Class<? extends OssImageWork> clazz) {
		return Stream.of(values()).filter(type->type.matchWorkClass(clazz)).findFirst();
	}
	
	public boolean matchType(WorkActionType otherType){
		return this.equals(otherType);
	}

	@Override
	public void fillFieldToMap(Map<String, Object> map) {
		map.put("ossAction", ossAction);
		map.put("workClass", work.getName());
	}

}
