package com.mini.framework.util.paas;


/**
 * 多site Bean
 * @author jayheo
 *
 * @param <S>
 * @param <B>
 */
public interface MultiSiteBean<S, B> {

	/**
	 * 得到当前Bean
	 * @return
	 */
	default public B currBean() {
		S siteId = getSiteIdReader().currSiteId();
		return getBySiteId(siteId);
	}

	/**
	 * 得到当前siteid获取器
	 * 
	 * @return
	 */
	SiteIdReader<S> getSiteIdReader();

	/**
	 * 根据siteId得到Bean
	 * 
	 * @param site
	 * @return
	 */
	//TODO 子类可以重写这个方法加上缓存。
	B getBySiteId(S site);

}
